;_GDIPlusEx UDF created by Eukalyptus!
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#Au3Stripper_Ignore_Funcs=_Flags1,_Flags2,_Flags3,_Flags4,_Flags5,_Flags6,_WinAPI_Base64Decode,ASM_DecompressLZMAT,_LZMAT_CodeDecompress
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_Compile_Both=n

#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>

Opt("MustDeclareVars", 1)
Opt("GUIOnEventMode", 1)
Opt("MouseCoordMode", 2)

Global Const $_cGDIPEX_ISBMP = 0x41455047
Global Const $_cGDIPEX_ISBUF = 0x42455047
Global Const $_sGDIPEX_IIDBMP = "{EB22CE37-EE56-458B-AD13-3FC836E8CE49}"
Global Const $_sGDIPEX_IIDBUF = "{1CB99E61-15BA-4B1F-8C7E-25D00AE60F2D}"
Global Const $_tagGDIPEX_BUFFER = "Draw int(); Gfx handle(); pBits ptr(); Width int(); Height int(); Stride int();"
Global Const $_tagGDIPEX_BITMAP = "Bmp handle(); Gfx handle(); Scan0 ptr(); Width int(); Height int(); Stride int(); Draw int(struct*;int;int); DrawRect int(struct*;int;int;uint;uint);"
Global $_aGDIPEX_ASMSTRUCT[1]
OnAutoItExitRegister("__GDIPlusEx_OnExit")
_GDIPlus_Startup()
Global Const $_hGDIPEX_MOD_GDI32 = _WinAPI_GetModuleHandle("gdi32.dll")
Global Const $_hGDIPEX_MOD_GDIPLUS = _WinAPI_GetModuleHandle("gdiplus.dll")
Global Const $_hGDIPEX_MOD_KERNEL32 = _WinAPI_GetModuleHandle("kernel32.dll")
Global Const $_hGDIPEX_MOD_USER32 = _WinAPI_GetModuleHandle("User32.dll")
Global Const $_pGDIPEX_LIB_SELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "SelectObject")
Global Const $_pGDIPEX_LIB_DELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteObject")
Global Const $_pGDIPEX_LIB_DELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteDC")
Global Const $_pGDIPEX_LIB_RELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_USER32, "ReleaseDC")
Global Const $_pGDIPEX_LIB_BITBLT = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "BitBlt")
Global Const $_pGDIPEX_LIB_GLOBALFREE = _WinAPI_GetProcAddress($_hGDIPEX_MOD_KERNEL32, "GlobalFree")
Global Const $_pGDIPEX_LIB_GFXDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDeleteGraphics")
Global Const $_pGDIPEX_LIB_BMPDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDisposeImage")
Global Const $_pGDIPEX_ASM_OBJ_QUERYIF = __GDIPlusEx_ASMCreate("0x538B4424088B5C2410890383400401B8000000005BC20C00", "0x49890883410801B800000000C3")
Global Const $_pGDIPEX_ASM_OBJ_ADDREF = __GDIPlusEx_ASMCreate("0x8B442404834004018B4004C20400", "0x834108018B4108C3")
Global Const $_pGDIPEX_ASM_OBJ_RELBUF = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B040075448B43388B531C52FFD08B433C8B53288B4B305152FFD08B43408B532052FFD08B43448B532852FFD08B433C8B532C8B4B245152FFD08B433453FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075504883EC20488B4360488B4B28FFD0488B4368488B4B40488B5350FFD0488B4370488B4B30FFD0488B4378488B4B40FFD0488B8380000000488B4B48488B5338FFD0488B43584889D9FFD04883C4205BC38B43085BC3")
Global Const $_pGDIPEX_ASM_OBJ_RELBMP = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B0400752A8B432C8B532052FFD08B43308B532452FFD08B43288B531C52FFD08B432853FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075314883EC20488B4348488B4B30FFD0488B4350488B4B38FFD0488B4340488B4B28FFD0488B43404889D9FFD04883C4205BC38B43085BC3")
Global Const $_pGDIPEX_ASM_OBJ_BUFDRAW = __GDIPlusEx_ASMCreate("0x538B5C2408B92000CC005183EC08C7042400000000C7442404000000008B5328528B5310528B530C5283EC08C7042400000000C7442404000000008B5324528B434CFFD05BC20400", "0x534889CB4883EC4848C74424402000CC0048C74424380000000048C744243000000000488B43404889442428488B431448894424204D31C9448B4B1049C7C00000000048C7C200000000488B4B38488B8388000000FFD04883C4485BC3")
Global Const $_pGDIPEX_ASM_OBJ_BUFGFX = __GDIPlusEx_ASMCreate("0x8B5424048B421CC20400", "0x488B4128C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFBITS = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
Global Const $_pGDIPEX_ASM_OBJ_BUFSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPBMP = __GDIPlusEx_ASMCreate("0x8B5424048B4224C20400", "0x488B4138C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPGFX = __GDIPlusEx_ASMCreate("0x8B5424048B4220C20400", "0x488B4130C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPSCAN0 = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
Global Const $_pGDIPEX_ASM_OBJ_BMPSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
Global Const $_pGDIPEX_ASM_BMPDRAW = __GDIPlusEx_ASMCreate("0x5756538B7424108B7C2414817F0847504542740E817F08475045417405E98E010000F30F7E4E0CF30F7E442418660FFEC8660FEFFF660F6FF0F30F7E6F0C660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000083EC20660FD60C24660F7EC1660F73D804660F7EC38B47148944240C0FAFC38D04888B571801C289542408660F7ED1660F73DA04660F7ED38B4614894424140FAFC38D04888B561801C289542410B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED8B5C24048B7C24088B44240C014424088B7424108B442414014424108B0C248A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C60483C70483E9010F8F63FFFFFF83EB010F8F3FFFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5B5E5FC21000", "0x575653415441554883EC20F30F7F3424F30F7F7C24104889CE4889D7817F0C47504542740E817F0C475045417405E99D010000F30F7E4E1066410F6EC166410F6ED0660F73F804F30F10C2660FFEC8660FEFFF660F6FF0F30F7E6F10660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F853801000066410F7EC8660F73D90466410F7EC94831C0660F7EC1660F73D804660F7EC38B47184989C30FAFC3678D0488488B7F204801C74989FA660F7ED1660F73DA04660F7ED38B46184989C50FAFC3678D0488488B76204801C64989F4B800000047660F6EF8660F70FF00B801000000F30F2AF0660FEFED4489CB4C89D74D01DA4C89E64D01EC4489C18A46033C000F8483000000660F6E063CFF7477660F6E0F660F60C5660F60CDF20F70C093F20F70C993660F60C5660F60CD660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10E0F30F58E1F30F53DC660F70D1000F59CA660F70D000660F70DB000F59C20F58C10F59C3F30F10C40F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C6044883C70483E9010F8F61FFFFFF83EB010F8F49FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF30F6F7C2410F30F6F34244883C420415D415C5B5E5FC3")
Global Const $_pGDIPEX_ASM_BMPDRAWRECT = __GDIPlusEx_ASMCreate("0x575653558B7424148B7C2418817F0847504542740E817F08475045417405E9DA010000F30F6F44241CF30F7E560CF30F7E5F0C0F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F858C0100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD283EC20660FD60424660FD64C2408660F7ED1660F73DA04660F7ED38B4714894424140FAFC38D04888B571889D501C2895424108B4424140FAF471001C58B46148944241C8B761889742418B800000047660F6EF8660F70FF00B801000000F30F2AF08B0C24F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1013B4C24087CE0660F70EDE18B5C24048B7C24108B44241401442410F30F2AC3F30F59C5F30F2CC08B7424180FAF44241C01C68B0C248B548D008A4416033C000F8488000000660F6E04163CFF747B660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF30F10D0F30F58D1F30F53E2660F70D9000F59CB660F70D8000F59C3660F70E4000F58C10F59C4F30F10C20F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E0783C70483C1013B4C24080F8C58FFFFFF83C3013B5C240C0F8C25FFFFFF83C420B800000000EB0CB8FEFFFFFFEB05B8FFFFFFFF5D5B5E5FC21800", "0x660F6E4C2428660F6E442430660F62C85756535541544155415641574883EC30F30F7F3424F30F7F7C2410F3440F7F4424204889D74889CE817F0C47504542740E817F0C475045417405E9FA01000066410F6EC066410F6ED1660F73FA04660FEBC2660F73F908660FEBC1F30F7E5610F30F7E5F100F5BC00F5BD20F5BDB0F12C80F28F00F28EA0F5EE90F57FF0F58C80F5DCB0F5FC70F5CC80FC2F906660FD7C7A90F0000000F85940100000F28D00F5CC60F58C8F30F5BC0660F5BC9F30F5BD266490F7EC04D89C149C1E92066490F7ECA4D89D349C1EB20660F7ED1660F73DA04660F7ED34831C08B47184989C50FAFC3678D04884C8B67204C89E54901C44C89E80FAF47144801C58B46184989C74C8B7620B800000047660F6EF8660F70FF00B801000000F30F2AF04831C94489C1F30F2AC1F30F10C8F30F59CDF30F2CD1C1E20289548D00F30F58C683C1014439D17CE14831D2660F70EDE14489CB4C89E74D01ECF30F2AC3F30F59C5F3480F2CC04C89F6410FAFC74801C64489C18B548D008A4416033C000F848C000000660F6E04163CFF747F660F6E0F660FEFD2660F60C2660F60CAF20F70C093F20F70C993660F60C2660F60CA660FFEC7660FFECF0F5CC70F5CCFF30F10D6F30F5CD0F30F59CAF3440F10C0F3440F58C1F3410F53E0660F70D900660F70D0000F59CB0F59C2660F70E4000F58C10F59C4F3410F10C00F58C7660FFAC7660F6BC0F20F70C039660F67C0660F7E074883C70483C1014439D10F8C54FFFFFF83C3014439DB0F8C28FFFFFF48C7C000000000EB1048C7C0FEFFFFFFEB0748C7C0FFFFFFFFF3440F6F442420F30F6F7C2410F30F6F34244883C430415F415E415D415C5D5B5E5FC3")
Global Const $_pGDIPEX_ASM_BMPCLONE = __GDIPlusEx_ASMCreate("0x5756538B7C24108B7424148B7614F30F7E4E0CF30F7E442418660FFEC8660FEFFF660F6FF0F30F7E6F0C660FEACD660FEEC7660FFAC8660F6FD0660FFAD6B801000000660F6EF8660F70FFE0660F66F9660FD7C783F8000F858F00000083EC20660FD60C24660F7EC1660F73D804660F7EC38B47148944240C0FAFC38D04888B571801C289542408660F7ED1660F73DA04660F7ED38B4614894424140FAFC38D04888B561801C2895424108B5C24048B7C24088B44240C014424088B7424108B442414014424108B0C24F30F6F06F30F7F0783C61083C71083E9047FED83EB017FCD83C420B800000000EB05B8FFFFFFFF5B5E5FC21000", "0x575653415441554889CF4889D6488B7628F30F7E4E1066410F6EC166410F6ED0660F73F804F30F10C2660FFEC8660FEFED660F6FE0F30F7E5F10660FEACB660FEEC5660FFAC8660F6FD0660FFAD4B801000000660F6EE8660F70EDE0660F66E9660FD7C583F8000F858F00000066410F7EC8660F73D90466410F7EC94831C0660F7EC1660F73D804660F7EC38B47184989C30FAFC3678D0488488B7F204801C74989FA660F7ED1660F73DA04660F7ED38B46184989C50FAFC3678D0488488B76204801C64989F44489CB4C89D74D01DA4C89E64D01EC4489C1F30F6F06F30F7F074883C6104883C71083E9047FEB83EB017FD748C7C000000000EB0748C7C0FFFFFFFF415D415C5B5E5FC3")
Global Const $_pGDIPEX_ASM_BMPTRANS = __GDIPlusEx_ASMCreate("0x578B7C2408660F6E7C240C660F70FF00B800000047660F6EF0660F70F600B8FFFFFF00660F6EE8660F70ED008B4F100FAF4F148B7F18660F6F07660F6FC8660FDBC5660F72D118660FFECE0F5CCE0F59CF0F58CE660FFACE660F72F118660FEBC1660F7F0783C71083E9107FC95FC20800", "0x660F70E900B800000047660F6EE0660F70E400B8FFFFFF00660F6ED8660F70DB008B41140FAF4118488B4920660F6F01660F6FC8660FDBC3660F72D118660FFECC0F5CCC0F59CD0F58CC660FFACC660F72F118660FEBC1660F7F014883C11083E8107FC8C3")
Global Const $_pGDIPEX_ASM_WARPMXPREP = __GDIPlusEx_ASMCreate("0x8B5424048B4C2408B801000000660F6EF8F30F2AF8660F70FF00F30F2A710C660F70F600F30F2A6910660F70ED00837C24100074060F5CF70F5CEF660F7EB250010000660F7EAA540100008B4C240C0F10010F1049100F28E00F28D80F5DE10F5FD9660F73D808660F73D9080F5DE00F5FD80F5DE10F5FD9F30F5BE4660F5BDB660FFADC660FD6A240010000660FD69A480100000F5BE4F30F7E010F5CC4660F7E7A20660FD64224660F7E7A50660FD64254F30F7E41080F5CC40F57C90F5CC80F59CE660F7E7A68660FD6426C660FD68A80000000660F7EBA98000000660FD6829C000000F30F7E41100F5CC40F57C90F5CC80F59CD660F7EBAB0000000660FD682B4000000660F7EBAE0000000660FD682E4000000660FD68AEC000000F30F7E41180F5CC40F57C90F5CC80F28D10F59CE0F59D5660F7EBAF8000000660FD682FC000000660FD68A10010000660F7EBA28010000660FD6822C010000660FD69234010000660F7EB288000000660F7EAAF4000000660F7EB218010000660F7EAA3C010000C21000", "0x4883EC20F30F7F3424F30F7F7C2410B801000000660F6EF8F30F2AF8660F70FF00F30F2A7210660F70F600F30F2A6A14660F70ED004983F90074060F5CF70F5CEF660F7EB150010000660F7EA954010000410F1000410F1048100F28E00F28D80F5DE10F5FD9660F73D808660F73D9080F5DE00F5FD80F5DE10F5FD9F30F5BE4660F5BDB660FFADC660FD6A140010000660FD699480100000F5BE4F3410F7E000F5CC4660F7E7920660FD64124660F7E7950660FD64154F3410F7E40080F5CC40F57C90F5CC80F59CE660F7E7968660FD6416C660FD68980000000660F7EB998000000660FD6819C000000F3410F7E40100F5CC40F57C90F5CC80F59CD660F7EB9B0000000660FD681B4000000660F7EB9E0000000660FD681E4000000660FD689EC000000F3410F7E40180F5CC40F57C90F5CC80F28D10F59CE0F59D5660F7EB9F8000000660FD681FC000000660FD68910010000660F7EB928010000660FD6812C010000660FD69134010000660F7EB188000000660F7EA9F4000000660F7EB118010000660F7EA93C010000F30F6F7C2410F30F6F34244883C420C3")
Global Const $_pGDIPEX_ASM_WARPMXSLVE = __GDIPlusEx_ASMCreate("0x575653558B6C2414B800000080660F6EF883C52031C90F57C00FB6D989D889C26BD20900CA660F6E4C95000F28D70F55D10F28CA0FC2C806660FD7D1F7C20F0000007406F30F10C289C383C00183F8077ECC89DA6BD20900CA837C9500000F841D01000038CB74330FB6F989DE6BFF096BF60931C08D1406660F6E4495008D1C07660F6E4C9D00660F7E4C9500660F7E449D0083C00183F8087EDA0FB6D16BD20A8B44950083F8000F84D3000000660F6EC00FB6F16BF60988CD0FB6D501F2660F6E4C9500F30F5EC8660F7E4C950080C50180FD087EE388CD80C50180FD077F3F0FB6FD6BFF0989FA00CA660F6E4495000FB6C189FA89F301C201C3660F6E4C9500660F6E549D00F30F59D0F30F5CCA660F7E4C950083C00183F8087ED6EBB980C10180F9070F8EEAFEFFFF8B7C2414B90700000089CA6BD20983C208660F6E449500660F7E048F89CB83C30183FB077F2689CA6BD20901DA660F6E449500660F6E0C9F660F6E148FF30F59C8F30F5CD1660F7E148FEBD283E9017DB831C0EB05B8FFFFFFFF5D5B5E5FC20400", "0x5756534889CF488D7120B800000080660F6EE84831C90F57C04889CB4889D84889C2486BD2094801CA660F6E0C960F28D50F55D10F28CA0FC2C806660FD7D1F7C20F0000007407F30F10C24889C34883C0014883F8077EC74889DA486BD2094801CA833C96000F84350100004839CB74374989C84989D94D6BC0094D6BC9094831C0498D1401660F6E0496498D1C00660F6E0C9E660F7E0C96660F7E049E4883C0014883F8087EDA4889CA486BD20A8B049683F8000F84E6000000660F6EC04989CA4D6BD2094989C94C89CA4C01D2660F6E0C96F30F5EC8660F7E0C964983C1014983F9087EE24989C84983C0014983F8077F444D89C14D6BC9094C89CA4801CA660F6E04964889C84C89CA4C89D34801C24801C3660F6E0C96660F6E149EF30F59D0F30F5CCA660F7E0C964883C0014883F8087ED3EBB24883C1014883F9070F8ED0FEFFFF48C7C1070000004889CA486BD2094883C208660F6E0496660F7E048F4889CB4883C3014883FB077F284889CA486BD2094801DA660F6E0496660F6E0C9F660F6E148FF30F59C8F30F5CD1660F7E148FEBCE4883E9017DB031C0EB05B8FFFFFFFF5B5E5FC3")
Global Const $_pGDIPEX_ASM_WARPVAL = __GDIPlusEx_ASMCreate("0x57568B7C240C8B742410B907000000660F6E048E660F70C00089CAC1E2040F29041783E9017DE8B801000000F30F2AC0660F70C0000F298780000000B803000000F30F2AC0660F73F804B802000000F30F2AC0660F70C0D2660F73F8040F298790000000660F6E8650010000660F6E8E54010000660F70C000660F70C9000F2987A00000000F298FB00000008B44241489874C010000C1E802F30F2AC0660F70C0000F2987C0000000B800000047660F6EC0660F70C000660F7F8730010000F30F7E8648010000660FD687400100008B4424188987480100005E5FC21000", "0x49C7C20700000066420F6E0492660F70C0004D89D349C1E304420F2904194983EA017DE3B801000000F30F2AC0660F70C0000F298180000000B803000000F30F2AC0660F73F804B802000000F30F2AC0660F70C0D2660F73F8040F298190000000660F6E8250010000660F6E8A54010000660F70C000660F70C9000F2981A00000000F2989B00000004489814C01000041C1E802F3410F2AC0660F70C0000F2981C0000000B800000047660F6EC0660F70C000660F7F8130010000F30F7E8248010000660FD6814001000044898948010000C3")
Global Const $_pGDIPEX_ASM_WARP = __GDIPlusEx_ASMCreate("0x575653558B6C24148BBD500100008BB5540100008B8D4001000083E904660F6EF9660F70FF000F5BFF0F58BD900000000F2875100F286D400F59F70F59EF0F5875000F586D300F597D600F58BD800000008B9D44010000660F6EE3660F70E4000F5BE40F5CA58000000083EB010F2845700F288D800000000F59C40F58C70F5EC80F285D200F2855500F59DC0F59D40F58DE0F58D50F59D90F59D10F2885A00000000F288DB00000000FC2C3020FC2CA020F56C10F57C90FC2CB050F56C10F57C90FC2CA050F56C10F50C083F80F0F8495000000F30F5BD2F30F5BDB0F5BD20F5BDB0F5995C00000000F58DAF30F5BDB660F72F302660FEFC0A9010000007509660F7EDA660F6E0416660F73DB04A902000000750D660F7EDA660F6E0C16660F62C1660F73DB04A904000000750C660F7EDA660F6E0C160F16C1660F73DB04A9080000007512660F7EDA660F6E0C16660F73F90C660FEBC189DA0FAF95480100008D148AF30F7F041783FB000F8FF1FEFFFF83F9000F8F9FFEFFFF5D5B5E5FC20400", "0x57564883EC20F30F7F3424F30F7F7C2410488BB950010000488BB158010000448B81400100004183E80466410F6EF8660F70FF000F5BFF0F58B9900000000F2871100F2869400F59F70F59EF0F58310F5869300F5979600F58B980000000448B894401000066410F6EE1660F70E4000F5BE40F5CA1800000004183E9010F2841700F2889800000000F59C40F58C70F5EC80F2859200F2851500F59DC0F59D40F58DE0F58D50F59D90F59D10F2881A00000000F2889B00000000FC2C3020FC2CA020F56C10F57C90FC2CB050F56C10F57C90FC2CA050F56C10F50C083F80F0F849B000000F30F5BD2F30F5BDB0F5BD20F5BDB0F5991C00000000F58DAF30F5BDB660F72F302660FEFC04831D2A9010000007509660F7EDA660F6E0416660F73DB04A902000000750D660F7EDA660F6E0C16660F62C1660F73DB04A904000000750C660F7EDA660F6E0C160F16C1660F73DB04A9080000007512660F7EDA660F6E0C16660F73F90C660FEBC14489CA0FAF914801000067428D1482F30F7F04174183F9000F8FE9FEFFFF4183F8000F8F93FEFFFFF30F6F7C2410F30F6F34244883C4205E5FC3")
Global Const $_pGDIPEX_ASM_WARPIP = __GDIPlusEx_ASMCreate("0x575653558B6C241483EC048BBD500100008BB5540100008B8D40010000890C24832C2404660F6E3C24660F70FF000F5BFF0F58BD900000000F2875100F286D400F59F70F59EF0F5875000F586D300F597D600F58BD800000000F29BDD00000000F29B5E00000000F29ADF00000008B9D4401000083EB01F30F2AFB660F70FF000F2845700F288D800000000F59C70F5885D00000000F5EC80F2875200F286D500F59F70F59EF0F58B5E00000000F58ADF00000000F59F10F59E90F2885A00000000F288DB00000000FC2C6020FC2CD020F56C10F57C90F57D20FC2CE050FC2D5050F56C10F56C20F50C083F80F0F8434010000F30F5BFEF30F5BC50F5BFF0F5BC00F5CF70F5CE80F5985C00000000F58F8F30F5BFF660F72F7020F29AD200100000F29B5100100000F29BD000100000F288D30010000660FEFC0B903000000660F73F804A9080000000F85B90000008B948D00010000F30F7E3C1603954C010000F30F7E3416660FEFD2660F60FA660F60F2660F6FEF660F6FE6660F60FA660F60F2660F68EA660F68E2660FFEF9660FFEF1660FFEE9660FFEE10F5CF90F5CF10F5CE90F5CE1660F6E9C8D100100000F289580000000660F70DB000F5CD30F59FA0F59F20F59EB0F59E30F58FD0F58F4660F6E9C8D200100000F289580000000660F70DB000F5CD30F59FA0F59F30F58FE0F58F9660FFAF9660FEFD2660F6BFA660F67FAF30F10C7D1E083E9010F8D2CFFFFFF89DA0FAF95480100008B0C248D148AF30F7F041783FB000F8F44FEFFFF833C24000F8FE6FDFFFF83C4045D5B5E5FC20400", "0x57564881ECA0000000F30F7F3424F30F7F7C2410F3440F7F442420F3440F7F4C2430F3440F7F542440F3440F7F5C2450F3440F7F642460F3440F7F6C2470F3440F7FB42480000000F3440F7FBC2490000000488BB950010000488BB158010000440F28A180000000448B81400100004831D24183E80466450F6EF866450F70FF00450F5BFF440F58B990000000440F287110440F286940450F59F7450F59EF440F5831440F586930440F597960450F58FC448B89440100004183E901F3410F2AF9660F70FF000F284170410F28CC0F59C7410F58C70F5EC8440F285120440F284950440F59D7440F59CF450F58D6450F58CD440F59D1440F59C90F2881A00000000F2889B0000000410FC2C202410FC2C9020F56C10F57C90F57D2410FC2CA05410FC2D1050F56C10F56C20F50C083F80F0F8424010000F3450F5BDAF3410F5BC1450F5BDB0F5BC0450F5CD3440F5CC80F5981C0000000440F58D8F3450F5BDB66410F72F3020F288930010000660FEFD2660FEFC041BA03000000660F73F80466450F70DB93A9080000000F859E00000066440F7EDAF30F7E1C1603914C010000F30F7E2416660F60DA660F60E2660F6FEB660F6FF4660F60DA660F60E2660F68EA660F68F2660FFED9660FFEE1660FFEE9660FFEF10F5CD90F5CE10F5CE90F5CF166450F70C2FF410F28FC410F5CF80F59DF0F59E7410F59E8410F59F00F58DD0F58E666450F70C1FF410F28FC410F5CF80F59DF410F59E00F58DC0F58D9660FFAD9660F6BDA660F67DAF30F10C366410F73FA0466410F73F904D1E04183EA010F8D34FFFFFF4489CA0FAF914801000067428D1482F30F7F04174183F9000F8F53FEFFFF4183F8000F8F03FEFFFFF3440F6FBC2490000000F3440F6FB42480000000F3440F6F6C2470F3440F6F642460F3440F6F5C2450F3440F6F542440F3440F6F4C2430F3440F6F442420F30F6F7C2410F30F6F34244881C4A00000005E5FC3")


Global Const $iWidth = Floor(@DesktopWidth * 0.8)
Global Const $iHeight = Floor(@DesktopHeight * 0.8)
Global Const $fCenterX = $iWidth / 2, $fCenterY = $iHeight / 2, $sTitel = "Rotating Cube with texture (use your mouse wheel to zoom) / FPS: "
Global Const $hGUI = GUICreate($sTitel & "0", $iWidth, $iHeight)

GUISetState()

If @OSBuild < 7600 Then WinSetTrans($hGUI, "", 0xFF) ;workaround for XP machines when alpha blending is activated on _GDIPlus_GraphicsClear() function to avoid slow drawing

_GDIPlus_Startup()
Global $hBackbuffer = _GDIPlusEx_BufferCreate($hGUI)
_GDIPlus_GraphicsClear($hBackbuffer.Gfx)
_GDIPlus_GraphicsSetSmoothingMode($hBackbuffer.Gfx, 4)
_GDIPlus_GraphicsSetPixelOffsetMode($hBackbuffer.Gfx, 4)

Global Const $hPen = _GDIPlus_PenCreate(0xA0101010, 2)

Global Const $iCorners = 8, $fZoomMin = 50, $fZoomMax = 150, $fMouseSense = 4000, $fDotDistance = $iWidth / 7
Global $fPerspCorrection = 1536 + 256, $iZoomCounter = 100
Global $aDrawCoordinates[$iCorners][3] = [ _;	X					Y					Z
		[-$fDotDistance, $fDotDistance, -$fDotDistance], _ ;0
		[$fDotDistance, $fDotDistance, -$fDotDistance], _ ;1
		[$fDotDistance, -$fDotDistance, -$fDotDistance], _ ;2
		[-$fDotDistance, -$fDotDistance, -$fDotDistance], _ ;3
		[-$fDotDistance, $fDotDistance, $fDotDistance], _ ;4
		[$fDotDistance, $fDotDistance, $fDotDistance], _ ;5
		[$fDotDistance, -$fDotDistance, $fDotDistance], _ ;6
		[-$fDotDistance, -$fDotDistance, $fDotDistance]] ;7

;       0 -- - - - 1
;     / |        / |
;    4 - -  - - 5  |
;    |  |       |  |
;    |  2-- - -|- 3
;    | /        | /
;    6 - -  - - 7

#Region
Global $aBitmaps[6][2], $i, $iMousePos
For $i = 0 To 5
	$aBitmaps[$i][1] = _GDIPlus_BitmapCreateFromMemory(Call("_Flags" & $i + 1))
	$aBitmaps[$i][0] = _GDIPlusEx_BitmapCreateFromImage($aBitmaps[$i][1])
	_GDIPlus_BitmapDispose($aBitmaps[$i][1])
Next

MouseMove($fCenterX, $fCenterY, 1)

GUIRegisterMsg($WM_MOUSEWHEEL, "WM_MOUSEWHEEL")

GUISetOnEvent($GUI_EVENT_CLOSE, "Close")
#EndRegion
Global $iFPS = 0
AdlibRegister("ShowFPS", 1000)

Do
	_GDIPlus_GraphicsClear($hBackbuffer.Gfx, 0xFF506070)

	;draw surfaces
	Draw_Lines(2, 3, 1, 0, $aBitmaps[0][0]) ;back
	Draw_Lines(6, 2, 5, 1, $aBitmaps[1][0]) ;right
	Draw_Lines(3, 7, 0, 4, $aBitmaps[2][0]) ;left
	Draw_Lines(4, 5, 0, 1, $aBitmaps[3][0]) ;buttom
	Draw_Lines(3, 2, 7, 6, $aBitmaps[4][0]) ;top
	Draw_Lines(7, 6, 4, 5, $aBitmaps[5][0]) ;front

	$iMousePos = MouseGetPos()
	For $j = 0 To $iCorners - 1
		Calc(($fCenterY - $iMousePos[1]) / $fMouseSense, (-$fCenterX + $iMousePos[0]) / $fMouseSense, $j, $aDrawCoordinates) ;calculate new coordinates
	Next

	$hBackbuffer.Draw
	$iFPS += 1
Until Not Sleep(10)

Func ShowFPS()
	WinSetTitle($hGUI, "", $sTitel & $iFPS)
	$iFPS = 0
EndFunc   ;==>ShowFPS

Func Draw_Lines($p1, $p2, $p3, $p4, $oBitmap)
	Local $k1, $k2, $k3, $k4, $x1, $y1, $x2, $y2, $x3, $y3, $x4, $y4, $z1, $z2, $z3
	Local $f1 = $aDrawCoordinates[$p1][2] / $fPerspCorrection, $f2 = $aDrawCoordinates[$p2][2] / $fPerspCorrection, _
			$f3 = $aDrawCoordinates[$p3][2] / $fPerspCorrection, $f4 = $aDrawCoordinates[$p4][2] / $fPerspCorrection
	$x1 = $aDrawCoordinates[$p1][0] * (1 + $f1)
	$y1 = $aDrawCoordinates[$p1][1] * (1 + $f1)
	$z1 = $aDrawCoordinates[$p1][2]
	$x2 = $aDrawCoordinates[$p2][0] * (1 + $f2)
	$y2 = $aDrawCoordinates[$p2][1] * (1 + $f2)
	$z2 = $aDrawCoordinates[$p2][2]
	$x3 = $aDrawCoordinates[$p3][0] * (1 + $f3)
	$y3 = $aDrawCoordinates[$p3][1] * (1 + $f3)
	$z3 = $aDrawCoordinates[$p3][2]
	$x4 = $aDrawCoordinates[$p4][0] * (1 + $f4)
	$y4 = $aDrawCoordinates[$p4][1] * (1 + $f4)

	$k1 = $x1 - $x2
	$k2 = $y3 - $y2
	$k3 = $y1 - $y2
	$k4 = $x3 - $x2

	If $k1 * $k2 - $k3 * $k4 <= 0.0 Then ;draw only visible surfaces -> max. 3 surfaces possible
		Local $aPoints[5][2]
		$aPoints[0][0] = 4
		$aPoints[1][0] = $fCenterX + $x1
		$aPoints[1][1] = $fCenterY + $y1
		$aPoints[2][0] = $fCenterX + $x2
		$aPoints[2][1] = $fCenterY + $y2
		$aPoints[3][0] = $fCenterX + $x3
		$aPoints[3][1] = $fCenterY + $y3
		$aPoints[4][0] = $fCenterX + $x4
		$aPoints[4][1] = $fCenterY + $y4

		If _Intersect_Lines($aPoints[1][0], $aPoints[1][1], $aPoints[4][0], $aPoints[4][1], $aPoints[2][0], $aPoints[2][1], $aPoints[3][0], $aPoints[3][1]) Then
			_GDIPlusEx_BitmapWarpToGraphics($hBackbuffer.Gfx, $oBitmap, _
					$aPoints[1][0], $aPoints[1][1], _
					$aPoints[2][0], $aPoints[2][1], _
					$aPoints[3][0], $aPoints[3][1], _
					$aPoints[4][0], $aPoints[4][1])

			DllCall($__g_hGDIPDll, "int", "GdipDrawLine", "handle", $hBackbuffer.Gfx, "handle", $hPen, _
					"float", $aPoints[1][0], "float", $aPoints[1][1], "float", $aPoints[2][0], "float", $aPoints[2][1])
			DllCall($__g_hGDIPDll, "int", "GdipDrawLine", "handle", $hBackbuffer.Gfx, "handle", $hPen, _
					"float", $aPoints[1][0], "float", $aPoints[1][1], "float", $aPoints[3][0], "float", $aPoints[3][1])
			DllCall($__g_hGDIPDll, "int", "GdipDrawLine", "handle", $hBackbuffer.Gfx, "handle", $hPen, _
					"float", $aPoints[3][0], "float", $aPoints[3][1], "float", $aPoints[4][0], "float", $aPoints[4][1])
			DllCall($__g_hGDIPDll, "int", "GdipDrawLine", "handle", $hBackbuffer.Gfx, "handle", $hPen, _
					"float", $aPoints[4][0], "float", $aPoints[4][1], "float", $aPoints[2][0], "float", $aPoints[2][1])
		EndIf
	EndIf
EndFunc   ;==>Draw_Lines

Func _Intersect_Lines($fL1X1, $fL1Y1, $fL1X2, $fL1Y2, $fL2X1, $fL2Y1, $fL2X2, $fL2Y2) ;by Eukalyptus
	Local $fDet, $fA1, $fB1, $fC1, $fA2, $fB2, $fC2

	$fA1 = $fL1Y2 - $fL1Y1
	$fB1 = $fL1X1 - $fL1X2
	$fC1 = $fA1 * $fL1X1 + $fB1 * $fL1Y1

	$fA2 = $fL2Y2 - $fL2Y1
	$fB2 = $fL2X1 - $fL2X2
	$fC2 = $fA2 * $fL2X1 + $fB2 * $fL2Y1

	$fDet = $fA1 * $fB2 - $fA2 * $fB1
	If $fDet = 0 Then Return 0

	Local $fX = ($fB2 * $fC1 - $fB1 * $fC2) / $fDet
	Local $fY = ($fA1 * $fC2 - $fA2 * $fC1) / $fDet

	Local $bOnX1, $bOnY1, $bOnX2, $bOnY2
	If $fL1X1 < $fL1X2 Then
		$bOnX1 = ($fX >= $fL1X1) And ($fX <= $fL1X2)
	Else
		$bOnX1 = ($fX <= $fL1X1) And ($fX >= $fL1X2)
	EndIf
	If $fL1Y1 < $fL1Y2 Then
		$bOnY1 = ($fY >= $fL1Y1) And ($fY <= $fL1Y2)
	Else
		$bOnY1 = ($fY <= $fL1Y1) And ($fY >= $fL1Y2)
	EndIf

	If $fL2X1 < $fL2X2 Then
		$bOnX2 = ($fX >= $fL2X1) And ($fX <= $fL2X2)
	Else
		$bOnX2 = ($fX <= $fL2X1) And ($fX >= $fL2X2)
	EndIf
	If $fL2Y1 < $fL2Y2 Then
		$bOnY2 = ($fY >= $fL2Y1) And ($fY <= $fL2Y2)
	Else
		$bOnY2 = ($fY <= $fL2Y1) And ($fY >= $fL2Y2)
	EndIf

	Return $bOnX1 And $bOnY1 And $bOnX2 And $bOnY2
EndFunc   ;==>_Intersect_Lines

Func Calc($fAngle_x, $fAngle_y, $i, ByRef $aDrawCoordinates)
	;calculate 3D rotation
	Local Const $fX = $aDrawCoordinates[$i][0] * Cos($fAngle_y) + $aDrawCoordinates[$i][2] * Sin($fAngle_y)
	Local Const $fY = $aDrawCoordinates[$i][1]
	Local Const $fZ = -$aDrawCoordinates[$i][0] * Sin($fAngle_y) + $aDrawCoordinates[$i][2] * Cos($fAngle_y)
	$aDrawCoordinates[$i][0] = $fX
	$aDrawCoordinates[$i][1] = $fY * Cos($fAngle_x) - $fZ * Sin($fAngle_x)
	$aDrawCoordinates[$i][2] = $fY * Sin($fAngle_x) + $fZ * Cos($fAngle_x)
EndFunc   ;==>Calc

Func Close()
	Local $i
	For $i = 0 To 5
		$aBitmaps[$i][0] = Null
	Next
	_GDIPlus_PenDispose($hPen)
	$hBackbuffer = Null
	_GDIPlus_Shutdown()
	GUIDelete()
	Exit
EndFunc   ;==>Close

Func Zoom($fFactor, ByRef $fPerspCorrection, ByRef $aDrawCoordinates)
	Local $m
	$fPerspCorrection *= $fFactor
	For $m = 0 To $iCorners - 1
		$aDrawCoordinates[$m][0] *= $fFactor
		$aDrawCoordinates[$m][1] *= $fFactor
		$aDrawCoordinates[$m][2] *= $fFactor
	Next
EndFunc   ;==>Zoom

Func WM_MOUSEWHEEL($hWnd, $iMsg, $wParam, $lParam)
	Local $iWheelDir = _WinAPI_HiWord($wParam)
	If $iWheelDir > 0 Then
		If $iZoomCounter <= $fZoomMax Then
			Zoom(1.05, $fPerspCorrection, $aDrawCoordinates)
			$iZoomCounter += 1
		EndIf
	Else
		If $iZoomCounter >= $fZoomMin Then
			Zoom(0.95, $fPerspCorrection, $aDrawCoordinates)
			$iZoomCounter -= 1
		EndIf
	EndIf
	Return "GUI_RUNDEFMSG"
EndFunc   ;==>WM_MOUSEWHEEL

Func _GDIPlusEx_BitmapCreate($iWidth, $iHeight)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBmp = __GDIPlusEx_BitmapCreate($iWidth, $iHeight)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRABORTED, 2, False)
	Local $oBitmap = __GDIPlusEx_BitmapCreateObject($tBmp)
	If Not IsObj($oBitmap) Then
		__GDIPlusEx_BitmapDispose($tBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>_GDIPlusEx_BitmapCreate
Func _GDIPlusEx_BitmapCreateFromImage($hImage, $iWidth = 0, $iHeight = 0, $hImgAttr = 0, $iInterpolationMode = 6)
	Local $iImgW = _GDIPlus_ImageGetWidth($hImage)
	Local $iImgH = _GDIPlus_ImageGetHeight($hImage)
	If @error Or Not $iImgW Or Not $iImgH Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	If $iWidth = 0 Then $iWidth = $iImgW
	If $iHeight = 0 Then $iHeight = $iImgH
	Local $oBitmap = _GDIPlusEx_BitmapCreate($iWidth, $iHeight)
	If @error Then Return SetError(@error, @extended, False)
	Local $iIP = _GDIPlus_GraphicsGetInterpolationMode($oBitmap.Gfx)
	If $iIP <> $iInterpolationMode Then _GDIPlus_GraphicsSetInterpolationMode($oBitmap.Gfx, $iInterpolationMode)
	_GDIPlus_GraphicsDrawImageRectRect($oBitmap.Gfx, $hImage, 0, 0, $iImgW, $iImgH, 0, 0, $iWidth, $iHeight, $hImgAttr)
	If $iIP <> $iInterpolationMode Then _GDIPlus_GraphicsSetInterpolationMode($oBitmap.Gfx, $iIP)
	Return $oBitmap
EndFunc   ;==>_GDIPlusEx_BitmapCreateFromImage
Func _GDIPlusEx_BitmapWarpToGraphics($hGraphics, $oBitmap, $fX1, $fY1, $fX2, $fY2, $fX3, $fY3, $fX4, $fY4, $bInterpol = False)
	Local $iX, $iY
	Local $tWarp = __GDIPlusEx_BitmapWarpCreateBitmap($oBitmap, $fX1, $fY1, $fX2, $fY2, $fX3, $fY3, $fX4, $fY4, $bInterpol, $iX, $iY)
	If @error Or Not IsDllStruct($tWarp) Then Return SetError($GDIP_ERRABORTED, 1, $tWarp)
	Local $hBmpWarp = _GDIPlus_BitmapCreateFromScan0(DllStructGetData($tWarp, "Width"), DllStructGetData($tWarp, "Height"), $GDIP_PXF32ARGB, DllStructGetData($tWarp, "Stride"), DllStructGetData($tWarp, "pScan0"))
	If Not @error Then
		_GDIPlus_GraphicsDrawImage($hGraphics, $hBmpWarp, $iX, $iY)
		_GDIPlus_BitmapDispose($hBmpWarp)
	EndIf
	__GDIPlusEx_BitmapDispose($tWarp)
	Return True
EndFunc   ;==>_GDIPlusEx_BitmapWarpToGraphics
Func _GDIPlusEx_BufferCreate($hWnd, $iWidth = 0, $iHeight = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then
		Local $aSize = WinGetClientSize($hWnd)
		If $iWidth < 1 Then $iWidth = $aSize[0]
		If $iHeight < 1 Then $iHeight = $aSize[1]
	EndIf
	Local $hDC = _WinAPI_GetDC($hWnd)
	If @error Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $hCDC = _WinAPI_CreateCompatibleDC($hDC)
	Local $tBmpInfo = DllStructCreate("struct; uint Size; uint Width; int Height; short Planes; short BitCount; uint Compression; uint SizeImage; int XPelsPerMeter; int YPelsPerMeter; uint ClrUsed; uint ClrImportant; endstruct;")
	DllStructSetData($tBmpInfo, "Size", DllStructGetSize($tBmpInfo))
	DllStructSetData($tBmpInfo, "Width", $iWidth)
	DllStructSetData($tBmpInfo, "Height", -($iHeight + 4))
	DllStructSetData($tBmpInfo, "Planes", 1)
	DllStructSetData($tBmpInfo, "BitCount", 32)
	Local $aResult = DllCall("gdi32.dll", "handle", "CreateDIBSection", "handle", 0, "struct*", $tBmpInfo, "uint", 0, "ptr*", 0, "handle", 0, "uint", 0)
	If @error Or Not $aResult[0] Or Not $aResult[4] Then
		_WinAPI_DeleteDC($hCDC)
		_WinAPI_ReleaseDC($hWnd, $hDC)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Local $hDib = $aResult[0]
	Local $pBits = $aResult[4]
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $pBuffer = $aResult[0]
	Local $tBuffer = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pBits; handle Gfx; handle Dib; handle DC; handle CDC; handle Wnd; handle Obj; ptr pGlobalFree; ptr pGfxDel; ptr pSelObj; ptr pDelObj; ptr pDelDC; ptr pRelDC; ptr pBitBlt; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pDraw; ptr pGetGfx; ptr pGetBits; ptr pGetW; ptr pGetH; ptr pGetStride; endstruct;", $pBuffer)
	DllStructSetData($tBuffer, "pBits", $pBits)
	DllStructSetData($tBuffer, "Dib", $hDib)
	DllStructSetData($tBuffer, "OBJ", _WinAPI_SelectObject($hCDC, $hDib))
	DllStructSetData($tBuffer, "Gfx", _GDIPlus_GraphicsCreateFromHDC($hCDC))
	DllStructSetData($tBuffer, "Width", $iWidth)
	DllStructSetData($tBuffer, "Height", $iHeight)
	DllStructSetData($tBuffer, "Stride", $iWidth * 4)
	DllStructSetData($tBuffer, "DC", $hDC)
	DllStructSetData($tBuffer, "CDC", $hCDC)
	DllStructSetData($tBuffer, "Wnd", $hWnd)
	DllStructSetData($tBuffer, "IsGDIPEX", $_cGDIPEX_ISBUF)
	DllStructSetData($tBuffer, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBuffer, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBuffer, "pSelObj", $_pGDIPEX_LIB_SELOBJ)
	DllStructSetData($tBuffer, "pDelObj", $_pGDIPEX_LIB_DELOBJ)
	DllStructSetData($tBuffer, "pDelDC", $_pGDIPEX_LIB_DELDC)
	DllStructSetData($tBuffer, "pRelDC", $_pGDIPEX_LIB_RELDC)
	DllStructSetData($tBuffer, "pBitBlt", $_pGDIPEX_LIB_BITBLT)
	DllStructSetData($tBuffer, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBuffer, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBuffer, "pRelease", $_pGDIPEX_ASM_OBJ_RELBUF)
	DllStructSetData($tBuffer, "pDraw", $_pGDIPEX_ASM_OBJ_BUFDRAW)
	DllStructSetData($tBuffer, "pGetGfx", $_pGDIPEX_ASM_OBJ_BUFGFX)
	DllStructSetData($tBuffer, "pGetBits", $_pGDIPEX_ASM_OBJ_BUFBITS)
	DllStructSetData($tBuffer, "pGetW", $_pGDIPEX_ASM_OBJ_BUFWIDTH)
	DllStructSetData($tBuffer, "pGetH", $_pGDIPEX_ASM_OBJ_BUFHEIGHT)
	DllStructSetData($tBuffer, "pGetStride", $_pGDIPEX_ASM_OBJ_BUFSTRIDE)
	DllStructSetData($tBuffer, "Vtbl", DllStructGetPtr($tBuffer, "pQueryInterface"))
	DllStructSetData($tBuffer, "RefCnt", 1)
	Local $oBuffer = ObjCreateInterface($pBuffer, $_sGDIPEX_IIDBUF, $_tagGDIPEX_BUFFER)
	If Not IsObj($oBuffer) Then
		_GDIPlus_GraphicsDispose(DllStructGetData($tBuffer, "Gfx"))
		_WinAPI_SelectObject(DllStructGetData($tBuffer, "CDC"), DllStructGetData($tBuffer, "OBJ"))
		_WinAPI_DeleteObject(DllStructGetData($tBuffer, "Dib"))
		_WinAPI_DeleteDC(DllStructGetData($tBuffer, "CDC"))
		_WinAPI_ReleaseDC(DllStructGetData($tBuffer, "Wnd"), DllStructGetData($tBuffer, "DC"))
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pBuffer)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Return $oBuffer
EndFunc   ;==>_GDIPlusEx_BufferCreate
Func __GDIPlusEx_ASMCreate(ByRef Const $bBC32, ByRef Const $bBC64)
	Local $iSize
	Switch @AutoItX64
		Case True
			$iSize = BinaryLen($bBC64)
		Case Else
			$iSize = BinaryLen($bBC32)
	EndSwitch
	Local $aResult = DllCall("kernel32.dll", "ptr", "VirtualAlloc", "ptr", 0, "ulong_ptr", $iSize + 16, "dword", 0x00001000, "dword", 0x00000040)
	If @error Or Not $aResult[0] Then Return SetError(1, 0, False)
	Local $pStruct = Number($aResult[0])
	If Mod($pStruct, 16) Then $pStruct = $pStruct + 16 - Mod($pStruct, 16)
	Local $tStruct = DllStructCreate("byte[" & $iSize & "];", $pStruct)
	Switch @AutoItX64
		Case True
			DllStructSetData($tStruct, 1, $bBC64)
		Case Else
			DllStructSetData($tStruct, 1, $bBC32)
	EndSwitch
	DllCall("kernel32.dll", "bool", "VirtualProtect", "struct*", $pStruct, "ulong_ptr", $iSize, "dword", 16, "dword*", 0)
	Local $iIdx = $_aGDIPEX_ASMSTRUCT[0] + 1
	If $iIdx >= UBound($_aGDIPEX_ASMSTRUCT) Then ReDim $_aGDIPEX_ASMSTRUCT[$iIdx + 1]
	$_aGDIPEX_ASMSTRUCT[0] = $iIdx
	$_aGDIPEX_ASMSTRUCT[$iIdx] = $pStruct
	Return $pStruct
EndFunc   ;==>__GDIPlusEx_ASMCreate
Func __GDIPlusEx_BitmapCreate($iW, $iH)
	$iW = Int($iW)
	$iH = Int($iH)
	Local $iStride = $iW * 4
	If Mod($iStride, 16) Then $iStride += 16 - Mod($iStride, 16)
	Local $aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", $iStride * ($iH + 4) * 4 + 32)
	If @error Or Not $aResult[0] Then Return SetError($GDIP_ERRABORTED, 1, False)
	Local $pScan0 = Number($aResult[0])
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pScan0)
		Return SetError($GDIP_ERRABORTED, 2, False)
	EndIf
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; endstruct;", $aResult[0])
	DllStructSetData($tBitmap, "Width", $iW)
	DllStructSetData($tBitmap, "Height", $iH)
	DllStructSetData($tBitmap, "Stride", $iStride)
	DllStructSetData($tBitmap, "pScan0ORIG", $pScan0)
	If Mod($pScan0, 16) Then $pScan0 += 16 - Mod($pScan0, 16)
	DllStructSetData($tBitmap, "pScan0", $pScan0)
	DllStructSetData($tBitmap, "IsGDIPEX", $_cGDIPEX_ISBMP)
	Return $tBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreate
Func __GDIPlusEx_BitmapCreateObject($tBmp)
	If @error Or Not IsDllStruct($tBmp) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; handle Gfx; handle Bmp; ptr pGlobalFree; ptr pGfxDel; ptr pBmpDel; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pGetBmp; ptr pGetGfx; ptr pGetScan0; ptr pGetW; ptr pGetH; ptr pGetStride; ptr pDraw; ptr pDrawRect; endstruct;", DllStructGetPtr($tBmp))
	Local $hBmp = _GDIPlus_BitmapCreateFromScan0(DllStructGetData($tBmp, "Width"), DllStructGetData($tBmp, "Height"), $GDIP_PXF32ARGB, DllStructGetData($tBmp, "Stride"), DllStructGetData($tBmp, "pScan0"))
	Local $hGfx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	DllStructSetData($tBitmap, "Bmp", $hBmp)
	DllStructSetData($tBitmap, "Gfx", $hGfx)
	DllStructSetData($tBitmap, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBitmap, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBitmap, "pBmpDel", $_pGDIPEX_LIB_BMPDEL)
	DllStructSetData($tBitmap, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBitmap, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBitmap, "pRelease", $_pGDIPEX_ASM_OBJ_RELBMP)
	DllStructSetData($tBitmap, "pGetBmp", $_pGDIPEX_ASM_OBJ_BMPBMP)
	DllStructSetData($tBitmap, "pGetGfx", $_pGDIPEX_ASM_OBJ_BMPGFX)
	DllStructSetData($tBitmap, "pGetScan0", $_pGDIPEX_ASM_OBJ_BMPSCAN0)
	DllStructSetData($tBitmap, "pGetW", $_pGDIPEX_ASM_OBJ_BMPWIDTH)
	DllStructSetData($tBitmap, "pGetH", $_pGDIPEX_ASM_OBJ_BMPHEIGHT)
	DllStructSetData($tBitmap, "pGetStride", $_pGDIPEX_ASM_OBJ_BMPSTRIDE)
	DllStructSetData($tBitmap, "pDraw", $_pGDIPEX_ASM_BMPDRAW)
	DllStructSetData($tBitmap, "pDrawRect", $_pGDIPEX_ASM_BMPDRAWRECT)
	DllStructSetData($tBitmap, "Vtbl", DllStructGetPtr($tBitmap, "pQueryInterface"))
	DllStructSetData($tBitmap, "RefCnt", 1)
	Local $oBitmap = ObjCreateInterface(DllStructGetPtr($tBmp), $_sGDIPEX_IIDBMP, $_tagGDIPEX_BITMAP)
	If Not IsObj($oBitmap) Then
		_GDIPlus_GraphicsDispose($hGfx)
		_GDIPlus_BitmapDispose($hBmp)
		Return SetError($GDIP_ERRABORTED, 3, False)
	EndIf
	Return $oBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreateObject
Func __GDIPlusEx_BitmapDispose(ByRef $tBitmap)
	If Not IsDllStruct($tBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetData($tBitmap, "pScan0ORIG"))
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetPtr($tBitmap))
	$tBitmap = 0
	Return True
EndFunc   ;==>__GDIPlusEx_BitmapDispose
Func __GDIPlusEx_BitmapWarpCreateBitmap($oBitmap, $fX1, $fY1, $fX2, $fY2, $fX3, $fY3, $fX4, $fY4, $bInterpol, ByRef $iX, ByRef $iY)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tMatrix = DllStructCreate("float WF[8]; float Tmp[72]; int DstX; int DstY; uint DstW; uint DstH; float SrcW; float SrcH;")
	Local $tWarpPnts = DllStructCreate("float[8];")
	DllStructSetData($tWarpPnts, 1, $fX1, 1)
	DllStructSetData($tWarpPnts, 1, $fY1, 2)
	DllStructSetData($tWarpPnts, 1, $fX2, 3)
	DllStructSetData($tWarpPnts, 1, $fY2, 4)
	DllStructSetData($tWarpPnts, 1, $fX3, 5)
	DllStructSetData($tWarpPnts, 1, $fY3, 6)
	DllStructSetData($tWarpPnts, 1, $fX4, 7)
	DllStructSetData($tWarpPnts, 1, $fY4, 8)
	Local $tObj = DllStructCreate("ptr[6];", $oBitmap)
	Local $tBitmap = DllStructCreate("ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0;", DllStructGetData($tObj, 1, 6))
	DllCallAddress("none", $_pGDIPEX_ASM_WARPMXPREP, "struct*", $tMatrix, "struct*", $tBitmap, "struct*", $tWarpPnts, "bool", $bInterpol)
	Local $iDstW = DllStructGetData($tMatrix, "DstW")
	Local $iDstH = DllStructGetData($tMatrix, "DstH")
	If $iDstW < 1 Or $iDstH < 1 Then Return SetError($GDIP_ERRABORTED, 2, False)
	If Mod($iDstW, 4) Then
		$iDstW += 4 - Mod($iDstW, 4)
		DllStructSetData($tMatrix, "DstW", $iDstW)
	EndIf
	Local $aResult = DllCallAddress("int", $_pGDIPEX_ASM_WARPMXSLVE, "struct*", $tMatrix)
	If @error Or $aResult[0] <> 0 Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $tWarp = __GDIPlusEx_BitmapCreate($iDstW, $iDstH)
	$iX = DllStructGetData($tMatrix, "DstX")
	$iY = DllStructGetData($tMatrix, "DstY")
	Local $tVal = DllStructCreate("byte Val[356]; byte Pad[16];")
	Local $pVal = Number(DllStructGetPtr($tVal))
	$pVal += 16 - Mod($pVal, 16)
	Local $tValues = DllStructCreate("float WF1[4]; float WF2[4]; float WF3[4]; float WF4[4]; float WF5[4]; float WF6[4]; float WF7[4]; float WF8[4]; float One[4]; float XOff[4]; float SrcW[4]; float SrcH[4]; float SrcS[4]; float TmpX[4]; float TmpX1[4]; float TmpX2[4]; float Idx[4]; float fX[4]; float fY[4]; uint Msk[4]; uint DstW; uint DstH; uint DstStride; uint SrcStride; ptr Dst; ptr Src;", $pVal)
	DllCallAddress("none", $_pGDIPEX_ASM_WARPVAL, "struct*", $pVal, "struct*", $tMatrix, "uint", $oBitmap.Stride, "uint", $iDstW * 4)
	DllStructSetData($tValues, "Dst", DllStructGetData($tWarp, "pScan0"))
	DllStructSetData($tValues, "Src", $oBitmap.Scan0)
	Switch $bInterpol
		Case True
			DllCallAddress("none", $_pGDIPEX_ASM_WARPIP, "struct*", $pVal)
		Case Else
			DllCallAddress("none", $_pGDIPEX_ASM_WARP, "struct*", $pVal)
	EndSwitch
	Return $tWarp
EndFunc   ;==>__GDIPlusEx_BitmapWarpCreateBitmap
Func __GDIPlusEx_OnExit()
	If Not IsArray($_aGDIPEX_ASMSTRUCT) Or UBound($_aGDIPEX_ASMSTRUCT) < 1 Or UBound($_aGDIPEX_ASMSTRUCT, 0) <> 1 Then Return
	If $_aGDIPEX_ASMSTRUCT[0] >= UBound($_aGDIPEX_ASMSTRUCT) Then $_aGDIPEX_ASMSTRUCT[0] = UBound($_aGDIPEX_ASMSTRUCT) - 1
	For $i = 1 To $_aGDIPEX_ASMSTRUCT[0]
		DllCall("kernel32.dll", "bool", "VirtualFree", "ptr", $_aGDIPEX_ASMSTRUCT[$i], "ulong_ptr", 0, "dword", 0x00008000)
	Next
	_GDIPlus_Shutdown()
EndFunc   ;==>__GDIPlusEx_OnExit

;Code below was generated by: 'File to Base64 String' Code Generator v1.20 Build 2015-07-10
#Region flags
Func _Flags1($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Flags1
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= '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'
	$Flags1 &= 'kpDjqx4b+5QpxQkO45/evCG7ujTRTRnk8/bOU67Lu0Ig0L2A/zCvBvyXrCTkSELOk4gQz4pkd2N2kokqYHNBySTnx5OuewH/yQg5kpAjCTlPX39cCWp8N7wqbdS6Oa+uTnV3nhJvhBxJyJGEnGd57Na6tv+J+n53bgT6RyHkSEKOJORIQo4k5EhCjiTkSEKOJAk5kpAjCTmSkCMJOZKQIwk5kiTkSEKOJORIQo4k5EhCjiTkSEKOJAk5kpAjCTmSkCMJOZKQIwk5kiTkSEKOJORIQo4k5EhCjiTkSEKOJAk5kpAjCTnSP+zVMQ0AAACDMP+edyBkTaoBLAcAy8FysBywHCxvByCCIcAghRFgCbp8AWAJugWgoJsKL2P3GYTExpzYq2MaZQIABmH+Pe+YEJoAVANgOVgOloMG5WA55C20XgZ2+MBbPpHICKgEYhhCAHnLJxJbF28gb8nyRIJ6gA1wGDDkDSGfSFwsb4C85RMJi3oDDXAYkbd8IgFYQW8Q8pZPJG+vDgJKUCkghvn3fB+A2Rg0EA2t1QJvAiaGeiDEKye1yUkQ6VNT7FFCAJAUUORE5CoEJgg='
	$Flags1 = _WinAPI_Base64Decode($Flags1)
	If @error Then Return SetError(1, 0, 0)
	Local Const $bString = ASM_DecompressLZMAT($Flags1)
	If @error Then Return SetError(3, 0, 0)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\ad.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Flags1

Func _Flags2($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Flags2
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= 'uLIsQI6KakjGVQkGbImfPB6SBxgMD0D4zvC04tXRf5rp83sB6Z1XcynleBXe95YPyLOUvfqCht7t2nFoxti6lJ3/fyQ1KRD2XthCjjVrg2YNRRvVzVROd3drRVMACbkKV8kLmgKcIFjCGtyZcgCBGOjHXB05ZR0MbIn1u7blPll9+AqMh8SPeCTtFmScIHwxKAhL43YIB9TTJFji9513IVkVeqMaqBszdXU8o3ZSG0Xk4V1HpDQAEBUdpnlgCR5mtbQBVhG/IfHgg+e1mIFBTswsDeTEbgpAiaKGS6HBtb7ezyZZ3ZqFHGvWBsN+bR1ZVxSrZjLEEtu1LQqIouYkzJIwVvQu0TMOV/IV0CLYvpBASGpq6iP78MPPgAEqXQiRgWQCMHDr2py82sFaC6schA9pHX3o4ERBpdjBTPRPU5HDfAXzW+VbapPQqtmTBuRZymdNVHs01C6IFn97NnpEe3mpOF754uxA2DtiCznWrA2CVSbNvXfvN1dY6auvvpSfRRMBAk18wG/i4ge0Hid/Q6Goy6+RKRF4Q5CKyk3ZtV64Zjw738Lvw0hcJTtqYRAqMviQsyMkwEMSXptN0db6uNJODEKFJFHM8GAGDGYB7JmTQ+a6Thk5pNaVN6a9L6gM3MpoZNukgeX56fzvesN0GXAW4tTPelZsMVD74dpA2DtiCznWrA2CNZUnuMo2XfkV0eoG7IGOoCgz7L2Wn5+vHqc8hQib6pFZ+wMqpK85QaQrQDWZccHjCyhyDbIvfFeornkksIEqTp5Qjbb9L3tn4hxFtYXx/+WVEjRBBVTIAkEWQcQlivAQVJRVDEQSLYmSBcgyCQmZhEkIIZlsMwlZ2AkQNtlEH4sBIayKvilFQPD9C+9XXN6t9t6eTj+gZKi+XadSM52e6e4bOF9/53znHLy8lQmRgwHJbEnSmjVrIHNWYCOJxTc4Q47Oe/QjncmK7LEtA5X6OCI2boTrsf1+Io0SMw7v2d0nmr+5tr2JcRf/2o+uMW2ickzd0nT20+0m4nlHbCDHmLGHYDQjsDodnVvIQSzsJ4ltW7uDT8Rr8yAv2IaCWEgMJJZISOCpXIqqBXdx6aNJ6gBRCLRAHcgQ0Tb9qmAYyNJoIsDByOf4KpIutvAASeLuyMeAZGKYP7VBImCFQx8QYFAfiMP0I910yIY+ktGBk4lmBMr0IAnVgOuABbOdVRX34VzqliyU33Di0MFvE9XJQN2jn/v9+vXw50sinnfEBnKMGXsI1rEh1xoEw5fpNf9kwqPNcUH6jLuUiGKbbiF5AxpBnnDuQmhgFRRwRqiG+ySHqCHVC1zANl1/DDNTaon0LgB8MBr/4O4UcuZwPUo9rBKvA1dA2WhgDKvjI+A9WAWnhAIqV8Uis4YOi/Plu9Puw7nsT32277vj95YiO0s/4GpyXLgmwNjTiOcdsYEcY8YegrUWjpfeLTMzE9hQcvikwRVnKjrBCMKhDK0h8oYLtvZ6gYvAG6g4UeBEydW7ZDlIvPhC227WyvEUuCjSACBHwQaYmd45RvkISAnS8FViBrNgGwqWsESsoZW7AL208wGqlbSNVdINHNp2sAZabFV8rCrScygdqR0FciCgn4568f78S93sGfcgJ8s+YTP/+Wd+TvG6FzaQY8zYQ7Ab3Qn7ygeFmqoFWuBe8WhWH5eXl6fHynCIIu0vFWV6XQtxpNLSUjgNIEGOxyHuxHmlpE3BNnyr+/7KoBrnwheLskpOqujWIBnwLfdDBABCCVoSq+AlwK21bw3HEAfjpJAqfnLLBOVk2I09HEBREeeCM6FmZmUAFaAOBIpW+gMWRhu0g4xQNO9R5hJ1JMXf51DOlKcCi+ZxU6E8+0bU9CmIeN4LG8gxZuyB7EpoSLBs/o7upksXL/Cc3tzYgAfEsaJpFqNZhIvEOco8vJ6ciOay+R6KY0iTSEepMKfysjLxcbHhxwVUAGPsF68JefEl/Hbnzh2QA2iEQo90iCL54awEgyXAflxCDsCp'
	$Flags2 &= 'yCWkSIw4nrhC6oqkyA1pg0stH/6dSBqw4TwsR1fcAVQ6TeTPVJWX8yAtn/lsS9rLuR+9f3iEGYZmzECOsYdtR2ue3xKuUCIzlZXsUTfy6kSHbDue4WSjAQCsBehS6mkuX77UsKG2uKgQRw/hcD+7DK4DS8Dh4rgFk4B+6WfEHeuSB31D4cbNClx0gByJlC4FaRBEB7Zk+1VcIQwyGnyyRPqCKxfAyvAloFfz4gUP7mgYpXPJEBpjBnKMPVzrb4zftaVZr/8AJByCS0qaBE9n62d5fse9Iju27tywvqbSX4FmDC+vO2sdJ5y9PzyD5JBQIlAqBBGxxQA+YlsQeu3aNSpdABvuCzEbZIjk0ANCDq5fmc+t9PqUKRxFeUH0jxVWFHRQHAKAEE3wXs9syQsAhGCErAarWj95TMTzjtKYgRxjsWgNBa/r7i8rKytajy9SC4qOi3yPVLiRnJC/ouQTGCAQh7yKNAaucGM4uLayggd22xCTe2E00BLteC4A77xixQpk0wTfrLyNPph69zZdrExwTCgL9J7NCLjdQA7nEtI499AFDnHlJIFEgS2JKCCQeB2hP5BSUjeulvgeyTPruvEWhJMXfPLI4W8Sve4ljRnIMRaLdjUUv2tzk85aGMMcLdIlBjyLri3QF/qSKRJqYIY+AuCNtaQxsLYq96ss3WUDAzhol5DjPIUafqCIHfg4rAXvzB0JzKCu0034C9eP6gyyIhCIO8LXczvggUuWo8CbImnTR/IAcgq5ga9wRr0VAgoFMmqgkVVoB1eTb5uIqnneSxozkGMsFi28KglPreMKwRxcnk5xqHN0HimNM8WPox62NtNsCzU1NzXIt4pvdQhY8VwPSLhsDIN3RqKmHwkJwHfn5+Uh16ZoFCrmRi/A7VMtBMZY42zoEaAjA8oBIBw03bEdgsBykYWClCgNdQBR13FFCZY6MDO480Zn6tCI572kMQM5xmLR2otfsnWg5GCYzgl+SGDgQR7pra1uSmqXccd4STBMPrbjfIsLcoqLVmmfs3ZfJhSkDbWUzXUCfheSBLWkXy/TIdIlOiMUFhaWlJQQD3RGOyAH4ZzteUE7bhkmh68XajogVsn8A07gnJKq4XihqAaPAcIBS5FAJk4ULSFE8kaHnNCKnF887yKNGcgxFquQU/Ky4svIu9AYRjSJAU5k82NcJJzA9skdcOK3wAPRHutjOHt8RSsgHzzFgysOqFO2Mv3w/m36/sP7ttTnpZ74xj4vguPGUztTH5lVYlMoEXE2v98v2tvYxsoEPOgbK4OgmegWZ5fQCB+ywhJrBaoRlJPxQ9iVddGQ7cnZPFwJ32k7KEjyNl06GAgEAB4r0AKTDUY4YMxAjrGYtTbfJAddssvMCg6UOBIYwywDq0/PyvxU7gG0ooXI8OwtxVNO1yW0+F7vrMvubi7ZFA50bshpLX/vZN2zXGSvP6m5PA9U06eRInFWeomiGuCFnp0iOR+tZohooRjkA6vggpWbdSmlowqHjwtBs8QSgnJQJdq72cbNOC9nAdTBbFGUqm/wJx2NWFtkBeIbADPZkm57sL4/0ciajRnIMRar1rN66J07tx1a+itcQXpGfcNvWt9Wr12jJMnJD/2oiYP/uHWjKm/6H1sSos7vaUj4bepTtPaqnzK2ZdFH7fnLuwKVXRWr23Ozw0sWVE9PK1k49z+WE4F8ApxcxtwUpRlSsVWrVlHuU7hqFbGyaAxDb4bNxhDu8vJy8EYBVGf0InQm9NkE+nQVA3AFusA7rfp1VtLa/kBoCLnrhrcmRTzvH40ZyDEWu3ZjU8L2zvXWDAF90uRbXSUsyzZ1tZh1APN33x7Tp5+xleV+EKqYs3tbaHNboCuY31GzuNuX+Oe2KJe3dcjN7PjImIErFokmhVb7fo1EZBc4rsdlKl6/EZGFgu7AWgAqNtIwVhgDJEAmlyOCYCEgh8MZYUVgG1SGKyT9w2vZURvkEzpvhNGsPAdQuAPA2EJpS/7yaylmWKcx'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= 'V/iTrJzXD/JJgl2ZDD5FS3QgXkKtpwR/bBFT3T7vL/RW+joQEvNdxJv0WzMXsGWPHeL2+dthQY5l753dLul27LBaaq4FFar9KciQ7IQ8igyaAQBkbrQcQgs5sCJDdSyhKoJvslpQ33yaFxLBI/8MhdIG2Xg3XAnlODxuPnXKkMrwtm9YlwPWGvInRbbnZMU2n/cXijUFdrni9cIE9NpJW7+GB3/RcCYlWNU5FuT4qD2p8W/N7XIgpYdz01f1SV8+rfV/r07PVZDgSb3KHB8hgLI8GjtJcoiAmLZpDeEv2eKMByRgDLrO/P67cPq4dSGnhj8ZLgbKAWSPICV6qKCGY+38Ofbliy+dPfO6bT1BOG/myOYHVGSk3g624jaqFY4K8x4SEv45ubkJnvpXjUfuB7vopODzN8WCHJ/LlJQnhJYVbbl4/iz6HEgDfrzWlVm6I7IiIeiXiu5/58ncLfU7m931QZmfst+WONYwq0GIiTQMKi8Tt07+Ji0tDXgAEqAm4BA8Ay2ZXM5L31yACJWgRArzgD/xzgwuEW8r1GtEz5APEBBTsKR0+SJ+ryeCuuVPGO5YPKdkyXx71ELb8u/t6TvMPVGpo+QNfdmLZ88cw/u7fd5Z6M0eHgxhlUTQpM3aoXJn2rABHNyxzqroOPg98GMzb89aOG2c2+dvigU5vkVushLm/uc///bUTqq+utCR8s/y+N4nM/yo89+7rWdZfKAroX95/FdHdvhfL+r67A340H1X99KE8IqM2RW5K6qK4mqcGUcP7blx46dDjdUVti2urOWOlBnF8UNccV/tT/Y7c7JJERkzZIZGWZOYEkt9baZkBnTiktRErzWQ0TDwTMs8CJfhRyQCyaS9SKLAmZQeoPZJowx/wWWDg+i7ZeKGOHtBvzo8suZFun3eUxja8YCPCazJdkSeEOW3589dw/s7FkR04OLT3gIdh+i1Q1aPKKhZbG3tSrfP3xQLcnzIKraGQWu8aS318893bt26SZkk/6XCyRI7OnP6WF1FfnHGquL48FuO1+NDZUnDDu5xSBgwT10cadi9bk7k82fPxEfzL43MTB5AtoaaStkomhJLffqE0kt5MK2FDWemLPmFKFYq02SJKAOA4UKZh7/Yw5KUEq2d/Twu0JkxfaK5LG3T6lUdxpu9JfaWED+3z3sKT1YaHyNyfibtXG1LF3Cka/Wy1734qFHEb8DLUbHFWsXAghyfsee7/Dd817M1/1OxCV+pSggo2Dbv0sXTHZDfHDlYV5wc0Zr/mTcfnbTk8+KCtFPHDyvlkOYDLGHyuGDBAtCO+hXiaVrVFgUxNBSgtyOkR89deC0hDlABAmGIqZuiluQv/75i25ayzbGZ307ZNO2bk4cPMUsFw1qOHY1ZvNC83Id8D9NbiJGo7zm+f19roGy7ohrtHTPHDj22p07fTJrQH/G6y62teenpHcCbXx66iwaHuH3eTZjY7gFfXj1/jqipyQRr+7hhD/p2pX3Da118bj0qeSXXyG+v9s+hn95VZqW7ff6OWJDj63Yis2dRyoJnT590wOU1H99XuHncndJ2GM/jKn8SNjft3Wq39HamTD91rMGbN4fcEEyT6+GjGhC5GdrS3LhxQx7GNJOWMwTByK+QfUG0xgP8yIYNG1gbX/+2rSePZ4wefEuXbD8X8JGz72dVQf5nAz6yDQ1VZHKAnFZTwJnIDtYAW8zc2e0HeYL98ufMPLFvryzk1NKv43sbNi1bCpa/Dr+xFVt444VljR5Exs5M7/fbbxmTx9C+weQY8/JeWDXRVyZA5tmgxjLXLUvlYUGOZVhVYhA6McqkO5A7ra/OL4gbdSH3lTQPKjhyP8fS/GoSvnDGhbi2DC5LHl+WPMYZ37cspketPd7kPcEMAAOPzJsDIdpUP2pmUjVKfT51M0gGYELAD16bwZGy2Zq2R1nhmhV7+7bf5N82vD8HM2nlgohzINzHB4EThjo0x/dzvPxBnw3umjtp5PE9uxXaxPj3ixfx'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= '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'
	$Flags2 &= 'uhxxA8BvXM52FTcAFF/O43a4n8QNAG9fjrgBIHQ54gaA0OWIGwBClyNuAAhdjrgBIHQ54gaA/S9nW8QNALWX0+LmLG4A+OrliBsAQpcjbgAIX06Lm2PvcwBQeDniBoDQ5YgbADKeg3XtUCNej6kAAAAASUVORK5CYII='
	Local $bString = _WinAPI_Base64Decode($Flags2)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\bt.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Flags2

Func _Flags3($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Flags3
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '5plHxpAhcECHaKfDu2sabNCGCZS7LsyMTqAUeUAnEqqlyfDaAU+FX6NUgTqPkrTSbRVfrtYFXyffUx3yOoW+mkALcHc+4ikG243OZAw+kzmEZM8+sHHgyhRH9YOf8Pj9LuPsQJ3WKW2GLZUj8vy1d8XoArqgddsfhYOgKK4wcATxb2preXkIX+QMGkQILJhjjY8Bsca1CaCaqkpvJRogAaiDRxi4KUtNk5MIUJdmz2eboUiLacWPjZIk/GQbnL/xUJXGU9rYMwtgnCiUqFnISUBVQoialBldHP4TwBuGInUaXRzzhsPFEXGUFhlDpdjQUGneer6hv4Vzp0D3zwoLStnaNKIDffr8ibGLAf3LO5siGI+kYhBrZgEDxm2IHb99nPhawVJCvX4/ESJHaF+why/eEt+sM3s3YeQku0/hvP6w5aFUhBRe3oU/FRIC6P69e8siI29eu9ZRiUGptebvDqjAtLV0LUjqVZgMPqPTHKtcZCf7JrnPhXC1ljSIsP1wPUlv/pzhUE1Q4qMBqR0oKGCCZzjEx7J9tSFQBkQB/MAQNqBLcZgu/CSfbjOqWzbgcqYBOEZAqYOLdG+vGbjeS+NV3kA4ZwoVce+y9Qr9hxP/pmoqKvgiZ97YscS/qTt37jipyQUzHREIf4FNkKECKqwUaNjjAfY4Mk90gkFJmzUzT8My5sUZzDBaDBM28BaADRAL6DXdQN9bSzGE9G9oTgoS85QkptLFGfKQwuHkDenimNIoNpLIUkMFKuP54+TTp4JVS7eWF3U+FBwfDnXZ7gJ/7nQIHmxBiOZHu/TwEvENgqWEev1+IkSO0Dqzvs55RHeocLE/Rg4csuO8bpRuBC6OZaXl0ftHiW5Sgc/k5rkoczRq8hBlU6eFRR2FQhsZiLC9SVJ/m6LxNl1rVZhdWcYiSO2UMdTIMrbCgeDxwFDql0WD83y1PlQy8VM9AgwgVBioDT/hMXmxcni2lya0MCDTNr4a7woHNeXor3NVhXK4d2t0oUih0G8Yrtw9Vrt/Q2Z8edK8ohjnovBZhQFTC73GFvhOKkoMvXj2JC5i/gpVFRWF8UNO2LRpxDfo8qVLiZERkCNxGTfax3xSsI1VtKtTvL9v2qKFe7ZvAwcCuqk6DOoHLggk9kNUJKfIUP1VSI8HsAEeD+msyEuQ7GkdTT1DgQY/2QYXZ8rTwuFOZplAJDNzYyFLBXQlhASFONrDrw1QpgFvIH8zSVqM279hncUxolLmSCKXCeOJbtLtV7dXnFkBxdDQrqk9b6hRyHbNTNyq4BsFCwr1+l1FiByhdWgzFtYQ3aGwyXoYObd+bhtiv+vXXa5bXOHPTKJbVbk66aEDumCFaiZRmknqUNt8nUg5nNeBaoI3iWrV8wx+u3b14vkz52P6VnmpNmXqQiUbxMTAUyn26fNiHfTFIfEDUAEDB6jAVxN+wmO4CAG0Qm8NMoZWMLDAU53p2fQ7H6N5P1kbckVQGpdm0yfJd0axz4ifg5WhfoEs1w6XgdzSpbm0xwwqVHKftBJZbiSabT+0LG0RFDoTXdTKhQv55nJiHByIrgvaw6xZnupgbDRKijpVAjlIIgcpykxJCmzxkDuB7R42fSc5cQeD/p7TLSaoK/krSQQAFZRotvLUEKbHYy5LZYbapCzlJHCaBxPIWoEWpk4+AIsiTRqeWjDdGmguEM70kwA57ipShw8c+P3+fWcDPX8mb3xa8zeesly8mUKjWEig2ZIodVEs0d2CXmowPmPvrb1lDWXQuomxYNy00chBH4+m7gbBgkK9flcRIkdoHVpkbjc4H82NDzFvPIfR//7vZ85EAtHdwk0/S+10wdFZMwY9cKQ0s30dnNchz4eSNWzb/Qce2lGNhyAU+I08Fa52YX4fspgtS/fZSp1STzWgCOAHXJ/3+WADH2T23x6qBQ/gKVyEly7G/wCIAtLku6hAPQJ4Nhg21+arrZghez6QBNvrWCWAHDhY4GbB6dRX82iPPKk5JiJlZpQ7'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= 'a1KkolVAE44sZoCysbS2pvT9FiB+Ivnvq/DxCg7a+N0PHJsfOI++vwxbyqUyUhXvH4EdNZJ95Hv0ofei6qf9p1jbG0wGgaY/aI4DrUxQTyLVGnYVc0ypQf3JagFrd85tnuva6Dq8Yrj8QnmXKpfX715zRA28eT3DeggFOZVzIwihEi4H6PYyQQQ5Iv6KLDEu++f7zwjhUVp+sFgQwHxEFEG597Le+Sd4xLkt2pMxodrKsthQL6/XF4T7P2a0EQwV3SUqy/cvImXTh3d/vv6TdbXQ1X77ftyNg+sPr8VviVy8d/6OS9ux1Ri6jri6BG27uBkxb3Kd3QjGEJ1CccEl75BcDKfmro7zzTTxPopSKdMkEW+InzrJs6Kk+yhKD/ATY5auye8kNoxgqI4u0dFm4BhhwNCY0daMDhM2bUpNdBg0IaNRIS1yfTC2OyL4ElUVDR8DhSwF6qkQixfzrPTk0Y00fy6FN2Gmii+f/UEIj3AhSIwTFVUTQY6IvzJH5u8hhEMoza+LYS7GzE/FrOZDv1m9IA0gQyDgyTue99nVrmXunhuwxt2ylD6scKBBgYJ2vrR6HjfYWJRqz96R6FZjY8oYtPnChqpjFYQwCBErYNVUfYa0gLJVqwCGVZOOEK1CvCuyTowWK7knC5RHyfTvL7ltRYfBZkORWL8BWFOnt04uMxVGLRtD0QQT9wzuPVEbg9CbMmd7ysh83d+e/3b5wQ+Ba6YYFpEmR8+6CXhoyd75ZiVDjBnKjhVmaAqj7JDGBYM6bY0cWqD84s2XvXdP/nqiXazN3n7No4JH9fEHv1zz1ZNsq+ApVMKFAN1eGoggR8RfnaXsc+4/fkkIg7D5FfgC/JMqMdIR1BIGgQ9AAEAYQAzArHYVINpC2uYrm/m0KH3w54Mff/vRtdL+HwOahG3ZsIydaZREc6twPny9mee52Hs/Ly9v3rx5c+bMSU9Pz8jIwDHu+fbbb69cudJOa2rUseZr5PagF/YeWtRveKGKTZmx32pX/SVDNAuYha418jmQTzMPffvMnJVvFoN7M4wl+yaQifrmqz7NXwgDtaWN9MRbtwgENi1rxTQ1Zfpq9lJfAFSVHcQw/Bxe81kdoGJg2R7HFBuPr7LQK5TBsW/9lLzmZdGbgifUWAxnDNQugrk7Upmy+8+27mpHbx6ZXOV8+8ktrF+HTerq19ePC7dJn5MenRTlFTF1fJBj6uxUz5gpo+cZ6jLE2MGMP+OdmJdoDsnqsWTvQuJL5Nboxl42DUOcEfJ5tDYPdqDwZo6HOameCo9wCeBCgG4vDUSQI+J/gxNLDxJdpvgN8SS6sHlx6FMg1kaj9eYZ73Jv1URViUAJcoLfp2S9BJQs3KgjvVga33YJvmSSre9QMSKk0RMVGvag21dvX/HIFtq5My4uDhsc/PEHtwUG95w8eRKrgiL8pKam7t69GxM4uEDu6oOrWEj76V9PqbJg136/tmh3BuNw/urTDXuu7Fp3ttGooB8rQM5sdVsej0ktc2Bag+n95EC7kLS5GZaBahooq0oZG0geqGsXbOqye2jq9JEfLKuaQmKMaR0MXETWDnA7AEOyeQh3bJmKRkiMkrAo0YvdNJ2s8H3zSOSGIJcy+zY14tWTDa3rLt3/nmdU+qFDh9LS0hCSa2trjx49iv09cT9XVwhs5hYYGTAsStO2bHhJS6F9uRmXCVG3UJoFRTqFknuu7EbP/6lfTl64d4E/PJSeLuV4EqKh6mjV59OO71zPjBrQFvvlynlCqIRLALq9HBBBjoj/JZZxynv852uiayQz/VM63uw22WHkRgqIstlhbebyhz8zDjAmMiYqzlAE30/4lM6BOtjjhOBLAkbZ3r17Nz4+vqmp6fND2D4Zuy9zydyDBw/OmjVr8eLFN2/yLvuIZ+HRdevWsWtF5+62+q5ysy4zGlmkblgkr1+KGTxULTJu1ivGOjTkwHrzp14AifCNvuSAAZLJYeIvzzOR5s33EBUorYRmNAM5lTQ0'
	$Flags3 &= 'oJG6i34JeZbBCvwkIYf+mUnNvEQLFRT2kHTW+M27N9g1FbW627d5V5q4c+fO8uXLU1JSEJs/snU2u3jxIqqDHh4es2fP5uo2jT9U8PSgGzduPHv9LHZz2JgVdIzXoPSexXvml3xXMLXBaWiR0tjSoQJqIW8/vOWoDJ0BPUJ6fD7t8f07rL6fNQtiCKESPvy4BKDbywER5Ij4P1vok5vwtZTEmzAO/DAfB//0Bl7Nw5Tx7P60ldNQvsCMtlOwcBbRZULdZeHCha9eveLClTVr1iAIeXp63rp1i9U7+YcffmiLuHv2rKysbMaMGRcuXGBv6Y9qEOLN77//jooRjufOnYsWOa6LJ2yN0ClmloEZVgP234L3Md4ZNpRRTqcINLKgv20P+X7SBgayVuYyfRR79rPtqZ3L9Axhbc3By5gFZryOg+1W0GdDGtsVw0MapyJvPM8DpBES8BdITEw8cODA06dP0YqISsy9e/dYEy5duhQdHc1gMB49esR+ItrWvLy8+vbta2VlpaysDAAKCgrsJyIh6CJQVVdX4xj1v20Xt2B4oVfDxPWt65i18p7c2npR0Oaz+27u41BxkkF7tjb3e8bHD2hJYzXFefVc0IAXURFPEeSI+D/KfVwK/nz1lugsqaepk5CTzAE5mUmTKTERaCR3/+efeJ74+v1rn2ofsWlilAdIKVupiznqjY2NlDTkorNnz6IUpl7t2WUoAgwKWQQe9ob/KIuTkpKwp/WuXbtw8Ocn8vbxc57gkZycishUUVExc+ZMrNXPUnrwHT99e3LOwWXDiplFEOhlZIEDpx3cpczGrMdsSnJgtY7Zq1QlFpTCaZpkaU5m5Jv7IaZag/mYnkfAtFbclDGYXtBHs5CZWpR9YCnBSdSdoxUxJiamqKjoyZMnCzMXOU/08JjqjbiCAIwqy6ZNmxA4k5OTc3JysM80dRb7rxEZGammpoZaEQU/5ubmAJCQkEB8RuvXr0crHNFlwih5rpZrgbWB3Klay1OoB8lHR+Knc8cJoRI+9vjwQ7eXACLIEfH/S4pOj+AeEMiBN+pF6tgnNM5ehxIWKROG8umms2zvMrHpYniWeKY4dkkgOktoICovL+d5CDFDSUkJpe3Lly/Z1Ro5Obm9e/dSm9euXUN9heXsCQsLs7S0/Ouvv9BMZ23r6Dn/h4hKYkLMxoWZmUzD2rlzaJVasWIFim9WG5g525M/DzXGVP8xGzB1n0P1QTgZkkOyYRnm9pObxlWgmoUzmROw6I5dE1nPDdOJ8Pq/PvsVA7hTtsVOrBx35+kdLu0EgRZvBvUwak9lZZVDUBHesPeia5Zj7dBgiHMcHBz8/f1ZrhpUgFBji42NZSFWr169Jk2axLrsr7/+KiYm5uzsTPAihDfEMKJrZLDCgANyQiFlUwpHBZpDOzHlk70NoEjFEbEIcv5/YEn7HLJ1W8fp4YuHpIoTywE5QVuD8NDtqxf96NKUvKiaF8nnIgXNBbQ42qD8QZ23yD9+jBoJnwnNzc34Cq+hocGKJliyZMmYMWPYEQgNSggk7KegmDYdaR5U8ATFN8V2jhMJNsIoL/QDlZaWIvBQ3ianCkvHylGIDeMrrXRLuCvNmNbD6LVi9ptlsYCbYTlZRcajBTUhBBgSkBy+RWQikcZxlabVCn39Qjm0wk2p5S30KTMXqlwINuyKGtJUL3/WDYcwnptbjEXkQHBlhQOgqTAoKAj/ZNSBEGipS9FoNAsLC9xkgRAABAS0a+1ExCKdPV2ggXkDOSAnGLL2ZLVFPfx2D/NvqOdnWbiLcKPUqFZskqJANRHkiPh/xQ7J64iOU92JOhJyUjggp6qVGXS0v7GCVXsNg474XEcvQ29U1Siis4QSH70X7R3Fpsj4+eLFCzc3N3RFUA4Y1Ht27NjBmrN27Vp85We94LP2+wdPM7GbHlr8kpLglg4+n8d0Xb9+Hb+deuv//cXvlNLz/M1zDBQmkaZQxqbMyG+1W0pT7NJ9C9H/sefKTmOG'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= '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'
	$Flags3 &= 'Ff8R/ws/gB/DD+Mj+CA+jovgUlSNhiDIcgiCIAiyHIIgCIIshyD+314dEwEAwkAAwwImmFgxhlA01UUHPnfxEADlAKAcAFAOAMoBQDkAoBwAlAMAygFAOQB8a58LAA3GmwsAGigHAOUAoBwAUA4AygEgnnIAUA4AygEA5QCgHADiKQcA5QCgHABQDgDKASCecgBQDgDKAQDlAKAcAOIpBwDlAKAcAFAOAMoBIF4BI8Gyk6NL87UAAAAASUVORK5CYII='
	Local $bString = _WinAPI_Base64Decode($Flags3)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\bz.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Flags3

Func _Flags4($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Flags4
	$Flags4 &= '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'
	$Flags4 &= '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'
	$Flags4 &= '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'
	$Flags4 &= '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'
	$Flags4 &= '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'
	$Flags4 &= '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'
	$Flags4 &= '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'
	$Flags4 &= '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'
	$Flags4 &= 'bD9d82MNPgQatLeqZpov0DUunu+7XVu4NqeAeg4/nDxVI42q47ruZQq3aAlWCudXh8rCzXlgrPGbzGQYptMV1WNZZzk3OTCYQhBUDoK8cE6ePLlsaWSJIf/pQZG3ZrLACtCdBYEyAjq13l7dSHa+6evb9s7GW7du/c85b4rYhL1HvrDPl+osdIIVcYR8gUnY/MJKxZ5dH9a0NtiKBXBEy8d1Xk1y16n9n33wt57vvqd+F1gP9KP3th0/chSWQhgeHg7SMoabLJ9hCiljmFTOMHv6v9igKwwAd/fYsmULhSAAqBwEebF0dHQAlJeXJ0TH5BsAC563Ehr0j20A1xFluvnAE/8AD+2JUNxZq58AHzy+9rO4UHoA4rF9BI72n3YAXZ1Or5Y2vUgAJl2n+HbgLPUARyiPTWzRF48AT2p4hjX1hNEB3v5VSmAuA4EwAIH88ssvzc3NAMXFxcnL4ktNAETwmN6jLS51APevjYqvlS9fAJ2YDss/r80vAD6hLCyo/xvYAC/AMcvjlYJIANo36nkhEY2pAPf+9eQeOQ/+AP2gYHsTszQWAM6ZWRK78+inANQf5Hx//9urAKrr07Prl2fUAMWl1EYlrAoIAO80IJ2EHXoSEHmgtABASkruDNHBJeD2IQRgcHAAsKGhAWqdWGkAaKIRd3ND058AUhBcuHpRWpcAJCwMiXsz9/AA2aPU8znUe8IAoTYlb+ta6k8A4vDnX6RbSUIAXdzhnyorK+sI7sYZBCUtDDCrAhgezVlZWaKGQA2wCKDcITsj/AlwHDhwICMjQwGiUKwmCCgE+UugAHL/4hAGM3nzAO/ro9R/2bdvAV97ezv1F+IuGgDwuEGv3rrbPwhwA4OZvFGB/gJgDGbyZig0kwpwafBJaVYRJPBPDYaOoMgaxoPiuxr6i+FjCMY2gA4FzqxBBWBQQOVgMDBnX/pnFmbHGoTRjz1Y4IYKhFIAQCUw2AIwL33OvvTPLAwYB0/Af9irAxoAAAAABGH965nIgCB8ewYgf4tv+WZDYfa3b0De8s2ifyvCuAFrpiuwOrjDA4e85ZtChXK7bwB5yzdrt/sH8hCWbxZ6u3/gLd8sTOi3+wbIW75Zgrt/kHcG8eqAJnULEIT1rwFnIoPw7RlgZfK2FMs3C+6+hyOvCwMAAACAIKx/PRMZDYRvzwBl8rZWwohn6DsAwzDMv70puo0EQwPR0FpV+CTw1gAB/vE5WEfR10AVcQcASUVORK4fQmCC'
	$Flags4 = _WinAPI_Base64Decode($Flags4)
	If @error Then Return SetError(1, 0, 0)
	Local Const $bString = ASM_DecompressLZMAT($Flags4)
	If @error Then Return SetError(3, 0, 0)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\do.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Flags4

Func _Flags5($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Flags5
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= 'mDNnzqC4uBgGDBqYXMqdisBOzWC81khNdMHOHVse63VJSrIFpysjMH6EBYPTY3Hr1i3Y0zcxErPHS70SU+M99tnDObIye3NOzs01ZK1HhRqp1Xh9RR/QFxMLLKaAij6j7xRF0cBEUZQGpLS0FAcPHjTtGqT1C8K+jcFYt8AfxjdsRgwJwd27d/GoLCiahlN7u5tqoqQkdcWJ6qOmcSnJ4fjHx73tAxPekz7Uwmc5h6n2CNfgWo8KNVKr8U0eAPqAvshOs5h2BIvoM/pORUVAWLgI/////5hs4MCB+Oabb0BKSrZi3UILVs7phPQ+bZCf6S6vUWyhHj/qR70+MlKj7BNJ5Rs4uRn+OHf2TO2x4eGh7KuzsY9jCJ/hs5zDLmGXaz2SjQbUSs3UTh/QFxsWW8Q3hL6iz+g7RVE0MFEUpYFhVdPo6B7o/VwgVs2zyJHcE+VhGJrmxnLu0rpZPXjE9qFFzQK7eCBrYDAyUiOxo3QT7t27B4NBqVIcrc6dkH5JIfJjv2P7ZhzZYYPRd6Yqwih2xsY+juFYPsNn65yTaxnQBtpCm2gbbaSt9UGN1Gropg/oC/qEvqGP6Cv6TFEUDUwURWkkWIBsWmHtbgVrevCbMv+8Eo9394YjMaZtvUmr5Msvv8Ss8RZ59t5n8ajcbENKUhBOvlMDkp1uq3cnhImlUybmIS+nj1HLRFpBlofpg3vs4xiO5TP1zce1CNemDbSFNrGPNtLW+qBGaqVmaqcP6AtjbvqIvlIURQMTRVEamaz0KNOPML/S26+3ExZM7oA3Nodi8aKXUB9nz57F6iIr7F/VTCwIworiIgxOjzLuSzLp2xXmQCU3MwR9k0z3mHxqH3RwDMea7nEuzmn8zbW4Jte2f9VTPCdUbK0PaqTW+ZM7UDt9YArW6CNFUTQwURSlkamurkZsTC/kD0tD5oBgJpTKjsWHRyOl8mpaUhv0fT4Eeyp2o6qqCufOnYOBkQy6e60RMJjb+kWhaN78GXz6Vk/+LTsROanmoOPNsnAE+JvuMc/Dfi6O4VjTPc7FOXnNNbgW17R/ljsu6X1cUF5eDmJALdREbdRIrdRM7fQBfUGf0Df0EX2lKIoGJoqiNCKZmZkwuHz5MuZOsjz4Tk1T+ULw5eOR6Or3LFa/3BmVm0JQPNuKjBQLZk4fg6+//hoXLlzA4um1wUB1mRV/vRxbW6xtTBDyBvnLtVEjxT4Zds96Sz2BSf1jOAfnMv7mGlzLOFVTuiKA38KRvw+VWBAW1Iq20mbaTg3UQk3URo3USs3UTh/QF/SJyVeKomhgoigKaZyqqywYZkoYHTpIggwUZHtg4vC2GDnYA717tIR9MHH+cCRSk4Owv7IC6Slhxn35cR+b62kKIKaO9oPx/LKZfvyyr33gUU9gUn/jHJzLfo3bH/TChoX+SIhuJbac3GMTDQH+7rSVNtN201zcJaFGjqNmaud9+oI+MaCv6DNFUTQwURSlkRg+fDhPmsgP8Lx5c7HjwXdrPjnRA9ERDshMboP4no51BgcMBBZOs6BDe098eKz2x/7lF9vD2K2wbxeOdMfCKb6PG5hwDs5lyl85uC0U4/O8sGtVIApzPbFoqi/2bQzBgARneHq0EVvtA6xr70XjdGU44qNaUSs1Uzv76Av6hL6hj8RXiqJoYKIoSiPy1VdfYdWqVfKaoncvG84eiIDx4z25wBtLpvlheKY7jCTTP/xWkmRNbfnsMBRNCeS1kUsiX+r9+0f1HOvt62KfLCvznjvYTUrC9450RMmyrrzmPfZxzEPnuHQsEtuLu+K1NUGItDqgMNcL8yZ2wJqizmLb4hkW44SONEPLJzU9cWBbKEYMcqdWajaCLvqCPqFv6CPxlaIoGpgoivIEGDsqG33ifJGf6cVTMZIIOmWUN7L6u2LF7E545aWO8oM9s9AH+zf/Z7Kr+UdfapFw98J0j3kbZa8GIiLkWQzq54KsFBc5lpuf4Y4ZY9tJrsfuNUF4Z4+Njde8xz6O'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= 'CEgqRm1DE2amtUEM/GSyAIIACJVfeABf/ar1CEip4DLKjOo9fzPYWWwvZYYh1JJKJSOPj7+tcjcuPxLrFjBxNa07f9yEKVSSc2kTD0qz/ofrZ8WiC/iagIglLODrvPLaf9vh8Ma6eM1/FdY0/Ss9X7lp+y9n1Gvps8TlwLtylv1188nL7y1Jjv1yJDM3q0D7l4df+8ef/H//7smUqaSgL7JMmTJHZPZKiLYR83LivCBirFAGxwlrGES0DsoIfk5rCnizsYWpHue0F0CciIbiCitmTINYcRK+6cXEeqi8Nfrag4gxIWBCSUCF2lhH3VSraw0Qfa+M7fa66mnEpOZhSUIBghJyUdO8EnOWaLFx0yYMDR3CtJw+LMjuwDJbJu5a8ZD7ZmhrnkdgYj601jSI9nPQR0Qi2BB7Y612JGXkcBfQzOIBj/xR2MZ+2zVmR/xiU9jELjS9ksCOcj7dTZ5E3NtjcrczR3X/zJEocn1VMSbcpWNLu7nFOSiAGZLgG/8GBQbg4bxF8A0I4v8OFv+aQ1XghktE9hwIq1b9+LpwiJq9ruuzK68rMOPrnVYNYbZAWGIh4uIhui/K76zMv6uUwESmzNEypQqi3wDFhl5EDGs5Wh67kWEQq29k9YjNJLUSrEWx2IdH+f8QYu3z4NttT0AoQ/vI6j5yLoTFgQV5LSo25JMfJpGlOgET8jHhX/PqmS7qtKSGTyQoZdv4g0eP49yl77Pe5eixB8kfhCcpb9ixG6fOXsAH16/DK6fDzXNDr+3Ej19/nf1KjEnZfHvoyDGs33YfC2A1gTo8evK7WBib6dZ6dzQcgTYhGwHWbJosTKUh9lpZak5FbGouNCFGAoQeCHPfRXJ2xKSAySBd6618rZx6o2QtxJrnbvo7i0LCGZgkhPpgs90beYbFmF5zAPx8xU6IjToVAOFrn5AJYVOXC3meTpxNvX5mA0SiDiIijEEsf4biHBDpOojDUc5jaZp1nFl+X2VKYCJT5t9T8q/yZNVMFv6VPkUXDJ5/w905AeDHHcU07G+4xGOC8vrbE8pxu+/duC21GfxY4ToIbZhzvWg9RIUfWCRr10Ck6jAzv0c11+Xacwl4YFsYzXGhNmHaNMcFJnp7tFtW7TFp+ez2evLkSXR1daGxsRGrVq0iDxPWNqSULKdz4O75YibEml2KP/7xj3j55Zexa9cuNDU1YdOmTXj88ce526eypQtTu85PrHupOYim9lVsTvbu++8js6KRxaIXLlzAho2buDsn0p6JxVF2eOetcvs9GpKj3QEmBAJVjFQ3DfDbrofI8QH7zhTpIKp3jq6HsRThQPpCBif3ODSYEzWCVWl4CKLLBZhsCocoHYCw8uwkdZpjVeU3kaJ1lhJpqGRVGE+o5sdc0xouv8MyJTCRKfPvJpXyzJyZEOl1fJs3ncQWNMwMwCybZrg7R8fTdEVsjHNDSAuBsqHPjitEc9RcTC/fDV4zKR+ieBlE43Eno0LApDcEomgxxM4ITI0rwOVHYlSzWqgbh0zVKAmYtNaogInKIXZJQqJ7HTl569Hd3U3eIMyUmAj/////UPzpT3/iVua1a9dioS3f43PmF5NCgwDZ1v5Xv/oVda2w/fqrr76Ko0ePwicmzd02YQI57EK7fv16Ak2czc3N2L9/P63HTruv3PjXP7XG7fendVjdASY8kfjzEeW0crpGj8Sw6y9f4xjL2FqWoi1YZ13AwCQiJID+W1SmdqLCBZhEBkAUboCICVWzJSkhEDWDI9iSFRCDKvCiLiu5PhYlgYlMCUxkyrw1c9vPJn9srBliIALCZIToOItFwQ5cm21CvrcPW85zp0ZuB0Sc3rkhrNdBVLHYE/PCE7Aiej5E3YPDmpN48K9do4Hvs9dIXjBERxDP4eHW4uhkHBl0/rL//skYnDtmQn3pIrTV+DNzsqJqdOfXz37sgCa71r0ulex2Zja+973v8aZfVVXFDq3PPvsse2j4pdd7fL4iMivx4Ycf4rHHHsP9'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= 'WZmBsrIyJM9FnxM1Hv04ahcQEwafOSI+qYjQSzI2YIm1SbNTxNPCtFk9o+RNdgSROJCEXPMZiVpXPluAmQhbsPoh1rD0QUIh15KKw6XESbD83dFi/uTG35wr16EBl4SneC2EdZ2uHkgCtaOUmzYVhvES/h5f/7SPP82tefiTP4w50JClm4GufDmV+eHvNaGgqUs/bzNfhwjIvJQiiLoCiKI0iGrp7bDqnUZzwWZWW6qBkByuy0eptQKZ/lakNY1hdf9xJI0+B5bZjsQnCoy7D8uSlG/B/zGagDvzGcOvPU7C8nyAHh+WgbQOqaBNxter61dBERMFhUcSJz6AiDSAA+9YkoiBfTIQbDNLOf48N/0g/yQ9iLyKBhSWVeBenxmV5Rb0ZFTwua+kupG6/lDiTp2Rp2G3lspwLq4RsBVj9cg18Pn+GYizPp2YHP4DpDdOIXnPm7r6Mv0ONm9llw7euRvEi5e8MTfrf/r7jTANWBYPNZssIVGgiqKVj8pS6P3g/RaSCYL5JO40bpwkFBrZiYWStVRG9PlCeZJo0IBKJUUeU202u3O0SHaSxUg2yQ8JSzNNoqARtToT+/db45Zw9o0Vy/h+xvi7fTL/JAwRiEJ4pXJTChpfm3K4Lk3IJWn65j+HtPpsXG03kZDc7CqA116GtR37SSpjfZ5UugbPgum/E3cgzvzxwqnWLcMQBxZpS+e5MINKVDRL+nn0jqyRYvAc2SxSjwj/////iVHXrYIiJgoKjyRO/xBi+BJEtBWi0gVhz5ozs5ooofNnp4m5HCwrHPXwG6+5NILbaU7sSavAup6TWLbnt1DvKsLdXjNK03MQyrKiuLBqqRsICUd+mUNuftwE/VYLI/MZjR+aI0x1HpRnl+FrqS60p5ciSW9PRuamGbz5YhQ0uk6W4sN3orGNsAcqsOL8Ir6GO0F2CJGcdNDMqhlQSRhIROrZpiuVBN1LctZNshKXnIyXLCztbNfblUlMGnNIFBhnz7wYGwkTVRttKnJbHhUdd2UGCUesv/HOJS/uXvby9vbtxVj2lBv8HHvzacylN2imgmuJ2wH+3XzvjaXQjin5tBNBZxroKwlZGKCWsHSy9SxEhwP0qdC74obwuqR5Wu/02vkaxInvQTQNQJyKmZkTu3W60SmVMnXtKihioqDwiIDmR0Z7hyNgiNlxD7+lx8v04CZzyMZNmSpC7los90aQVL8ZYvMpiA3HsTorD7sCmbjQms+o8kp7KZw2KyrsDpQ5PChy+VHgDiPXE0V2ZTMyIxuQ1jKBtd0HsWLwAsTQFeQWWDDbkIuzTXnIdFaD8eUjFyGe8EIMO9GTVko15n6q8+Hrjhtizktq6/BvftTGLpQtvQXs1onVpeLWSzoLNkMqFet1YqLNoSExcaayg4abfFkKwfRVyxp6QOatGe+ckhyQsOwpk+9B0sGcj6pMptWSmJye6xY64ZDnn1knptFifBCHeP3hWzV4YncZb3/jtWpkT5ToZl9pHj1qNxwLs2pqWCpBcmEqkrYWYbl1HZJzV6HdmwFr+f9l78ujoyrzbT+IgJB5TlUqYyWppIZUpTJUZarMc0JGMmGAEBLCjIYAAhJEBVERZFAUEBABtcXh9b3edqJV1LbvtfW23Vft4fU8d7+e52k/vr04q/qkUhDt9/5oPGetvUhNp06d4qxv1/7t3/6l4PqO7dMrC1Zx32pUZ4FEpLgOHMi3Qqo/mRDz10J4WiDmy78l4ZUThXMhWrLUqbD3OdQek3KT3J92HWvQiIkGDddE/Hz9UgiPCWKLWflFOl3Q8KmklrIrZZ+D93FhmzCzWyUoeg7Wu6KwsTgat5bH4kCDfpJpkuAk2n11OuyqjOUAuLHCKIzmR6EvJxbzM8PQkhGMwsQgZCXrkZZmRHJcMOLjAxEXHoz0kFDERaZQjZlcknJVWtl98uN3atBSHYuffbF2ysX7P/+tBDH+E2ElMVCICkswJBzDbNul34QGWLb8MnuDRIWmVHuYX3LC'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= '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'
	$Flags5 &= 'CnCjpEMLNGv4YNRlTRxIDZ/H4GqVb8hwuXjpstgzZxCU5vb3h0KhxEShUNxzROeUk0WC0kCSK74SOm+MedXhcJABQnmEtFVabzGMUraBvBCOhqeDMgrpq0ZRKSkpMeZXx5x6lyvbUp6JDA22SIkp4/gHhZogMfP+qtPm9Z5pfub910v8JTXSX4aVLHX6HtQMD79gzKkoJMTJkxxrfCObN28GlHIgIrQDc14s6IfCY4hWcXEx+xlScuDAAfY3oWoT8sqZg9vfFwqFEhOFQnFfMGKWWaCPThUWt0PxMGpIZmamXLlyRb777jv8JHS6UOKha8UKHyMoDWMp++HLIHkVD4op6wRlz3IdABebJu35xuhqkBAW0Ktc82B9p2TF2M37FkrH+8mIVGclg2wU+6QieWXXHspQqDcoOrQHo5DwLwoK5ATggYFQ4SfBO4PXhMUDWWPHLDy44/V9Mrz6Zbe/JxQKJSYKheK+GmHLaxvFGj/99JMwaLclUIz4d1bkRV1AbaC0Q0kHhSF+SpFUNy6Wt97pkq+++sqUft488LaEZzjkwaYPeh3roeptkhs3TiyyMTPJXx4pW+6aMKVWyNKMHgIDmjN8xTssAdXFSTl5qHanBOTMlviCKrGQMCndqCYXLlzoFZLG3M+ePYsyBOFCCTLG3pCcmXo/KBRKTBQKxf1GWG6lFazmtC4NKgTlGmsxPaf3f90ituZPDLEZXNchHjNXyWOVa+Th6u0syd/rGMOmNUtalF0ss2ttir+MTHb0a84dGxIlrxX7OZGTbQW+Yg8KEdvKv/Z7Tp5lz8vJL065NMBybqTWAtQiTLOz5z9DO7Xb3wsKhRIThUJx3zF0brsc/NMhkZ5BxwplHTwcdOaQX+L0/vj8m1MXUDRGpFVKeaIhFtIxzU+SwsfJ0IJFN9z3gWffk/HhxiTrhLacsTIydXp/++ITwefitG6OtaaPlVPCeR06dMjkm4ybOsft7wOFQomJQqEYGHixW3IqamidpfRhouYZeDYII8M02t7ezna6d8x2/4L6G39va7eMisuQhZN8DaF4pchXgoKCZFDD72+eNJW+IAXxzn4TMDEq4IYKR+q0KmEcPnyYDhz8MVasvnl98eJF0zZc8/RisTV9oPeBQqHERKFQDBTYC+utBzeBZPguWC+G9mFKHkS0Gx9JeXm5dOx9QwbP29n/dy47IaND42RVlmn9lc7/IyQ4SGzNR29d0SlZKjmx9l4lHa/Y1H73i8mtkK6uLmlra8Ooa8jI+fPnMcBi7DWK0OnTp2VcXo3bX3+FQomJQqEYcCbY9GmVmEGJmyckjTVwTPvtxx9/zMMdmG6X0JgEsa0+0+/3eUckyZae7huZkWSXh6s23vb8Hpm+qlenTl7cOBm08EDfZKvoSdO6fO3aNQgVqg/lG8gJXTqGiGWUVEGi9PorFEpMFArFQMOIORtk+84OulYwvlpR74acrFmzRqKiokymiWdgRP8KR9GzUpPcY1p9tchXPGNSf74XZvpKyYuzO2WgBAQFywN9lHQebDokUYkpJlI/Ly9P9u/fLz/88APlG1Oy6vjtm/JYVZvbX3eFQomJQqEYkMCoOnZqjbSu22B15WASxSyK4mA8Jn94620ZNevFvlcLzqqVkvHOfpDJ0YFkjtyROQ4raRFHQg852VHsJ4GQk6b3XX++frdExiaQXMtihJSqDDnZuO01GVPcqLHzCoUSE4VCMdAxuuApWbCoCXJC2BrJsMCoDhMKKmjldUFq/i4jkqfRBuxEGuLCAzGw3tH5Dc+dL09N7CkT0VIcFOgttob9rqP36/aIb+IUmT1/kcx7erFMyC8Xj8pWt7/OCoUSE4VC8YvB8LlbJCotTzKnTDGrCaekpEhyjkMebdjruvsmNl2a0kz3jcHmPB/xDwmnzHJXlB3vsHjZXmiOJxunjpXZRT4SETZKbCtP9b0fuSvPf+L211ahUGKiUCh+kSD+Hd+J1+RyGeN4RmwvfO7ycwHh46Qm'
	$Flags5 &= 'yVMsUrIyy1e8I8Zb69/cHSw5InGhAeZ4lRNGyTcnsmX/y4kyZMo8vW4KhUKJiULhrhhS0iKrFoVLwSRPSirG6DomNNYq99xVDMtbIE2Tx0rBeA/57z8d8p8LBRIcaXf7a6JQKJSYKBRuC3tCglz5PEve60yWBRO9JC4swCrf3HVAfvyDwqQ4xRNiYhATM8btr4lCoVBiolC4LYJiQuXff8uTf52eKjmxHjK0+Ll7q9jMWiupMR5y7XKhISZRUUpMFAqFEhPF/9izQ9UE4yiMw2EIE5vILPIFnQoOxOFsIhbXDF8zCMNiMS97AXaTd2CxDrwGg3exqziC4C2o8H/C019O+sEhWa+jeey3/Tj/jaJef7u9cO6qmmVx2H1dw6TdFiaAMIF0/R5j8FmJn7wWxfHiMRtW++h9lOP/NIlmS5gAwgSSVvpeRtZpPHRDIV/HoFuOxrswAYQJ8AReZpuoDKfJ3wEQJgCAMAEAECYAgDABABAmAIAwAQAQJgCAMAEAECYAgDABABAmAIAwAQAQJgCAMAEAECYAQOqSPwAAIEwAAIQJACBMAACECQAgTAAAhAkAIEwAAIQJACBMuLBbhwQAAAAAgv6/dogEDpgEAIwJAGBMAACMCQBgTAAAjAkAYEwAAIwJAIAxAQCMCQCAMQEAjAkAgDEBAIwJAIAxAQCMCQCAMQEAjAkAgDEBAIwJAIAxAQCMCQCAMQEA9vYBAABjAgBgTAAAYwIAYEwAAGMSu3VIAAAAACDo/2uHSOCASQAAYwIAGBMAAGMCABgTAABjAgAYEwAAYwIAGBMAAGMCABgTAABjAgBgTAAAYwIAYEwAAGMCAGBMAABjAgBgTAAAYwIAYEwAAGMCAGBMAABjAgBgTAAAYwIAYEwAAIC9fQAAoHbrAJgEAAAAYFD/AdbLMfCwg2LDhSGv64URiBUDJuuFUS+GcWg/wPoFAMBdm4hjdk3kQPIhAgAASUVORA+uQmCC'
	$Flags5 = _WinAPI_Base64Decode($Flags5)
	If @error Then Return SetError(1, 0, 0)
	Local Const $bString = ASM_DecompressLZMAT($Flags5)
	If @error Then Return SetError(3, 0, 0)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\sm.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Flags5

Func _Flags6($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Flags6
	$Flags6 &= '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'
	$Flags6 &= '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'
	$Flags6 &= 'dakfE1U7f9efvr7e4L+7hpSEU0/kWyrmt4/rL93TDVFQ/ZOScXpToSVr8Qf62ycUb6Ji9rdKysC2xZaEooYvdEE77wVHR1mPknSsaYY5yVnVPqKLWijlRElRh5I18Wl9hSUob/nL/brEM4ZIyd+hFHzzem2Z/Y/cJU0fjehS8TWGqFkbV0p6X21cMTPLLqdwYW3z3kH9y5GbDNFz81GlbLi7rXnD2gdW3j6vonz2rcvuqW14qmV/ny7njamGKJr6pkIzxIETXY8OKRw9lYboqupUCCa25RuiLPuxAQWta5Eh6kp2KFBn17NSywhLexScnaWGzJDz5KCCcfQOQ+Yo2zKs9DtZT5U8w5Q8f07p1bsmx5BxijefUfp0P8jkmqEKY/1KjwOraFhksLyH94wpVb+0sCjJeKUbDykFo7vvo4QzOcx54Qcl5+D6qwyTRvaSpv3n5ebHtoYbDJPNlcuaPxtVYs7s3jCHoXXSKlgRe+vLAf2Hie/3bX38Fi6/sNKl9S/uOXTidFwXjZ/t6z3Qunn1ggID/il7Wnlldc2CWaUEFgEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADgj/bggAQAAABA0P/X7QhUAAAAAAAAAAAAAAAAAAAAAAD4C8bw4apoVyp3AAAAAElFTkSuQmCC'
	Local $bString = _WinAPI_Base64Decode($Flags6)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\tr.png", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Flags6

Func _WinAPI_Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_WinAPI_Base64Decode

Func ASM_DecompressLZMAT($Data)
	Local Const $MEM_COMMIT = 4096, $PAGE_EXECUTE_READWRITE = 64, $MEM_RELEASE = 32768
	If @AutoItX64 Then
		Local $Code = "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"
		$Code &= "5/o1kEQsAf7ChQJKEWf+KPU06QsjULCtlHGUMyrwiJMbCggKTje0+TgXdGmQGXisYu9BxgKaIwr4HApKAQw/fMgSArJnA8oeSdHJqVNxagiueGUCImaKKhdshPB5iEkCHQnGQAMYF+nk0TdpgoAK8OuH/JE5agKytTp0np6Md2oBNUARWlgo5ukqCBEPM8DqFFEU4sX7H0lHQRVGyjMdg+gB5l6gi9M1J/HokAOWAfx2ZkGJJMMQiQIWuiDb/YIUHMFqySVhq4Q/EoD5Ib0MLCkZJjioUnA8/SgzlwEgZ+l9+kmBIKC0SwEvhHYkd/kuc1LVL4gDxlvdTLhpnpUVrlgn0tgHBqF6VvdwlLTPoJJ25AaLKogBuFfhaNsouwhkkD30gC3PKfdMOUUXg6RCPEWE5GmqAgGJ34M5dDgBRS4MLEkU5osYwO0ICfUwg8MkMfbrGC6J3jNUMPudSzS61JpAOsDuDkQJ1uWIN6HSnU1B2MYJ/ggfdJxF1O1noN92jOjoIHOIFu14FBrh3UCvPDk0dbGeRUnrwDOA0IQkEmvC5TiHZDxswO9VBGiYGv/Q1z2Uv0e3v8aGuFuA7/qDMecDPuoC3f/PO4A1wZASAyFgkAEpOdKgg1TWthyYWinmP54MgPQ1rpzBR+OdCEYCHEO1BcMDOcaC9fR5oBo8GGDxgnnegRnF2iZt6RmJwkbrjn4p8qoMCSAYRQ6cvNeaxiJiGCSvOZAFRYXbkA70MXZ1sTmh0KG2oM9Bt5W+SEs/+hTR6rtEiKKLuvOtooQEl+AwB6Sx8Mb1KK6aJBq4YaVSQDXA6wSRHIq227VjhUtlKx3UBa18GgWXOfkOr+nyMcp0ZSdGEbZc1CMS4wQlSgtC30Omp/KB+1oPKnRQ9EQShmkMl24oN7gEjZ+pwxjrLDDTqDNh1hKn5n9lRwVE6bcp2xQSMVB1sGCmVDoaAtoCuIKBAW5VeSOErdLKzbsNjZ8RTZmcApMQdecB3HP+FAg/JJ+NmvzUTHOjIt7TkJgYBb9/EUQhUO/8PnQEJDQ/sBD4jRJdaLEkJ5wDdiOD7unrB7ILGRdBcdoxdoGIBEeLFBAsbWhG0TzMfyziHYvp8ajvXg6NsmoEqsjRi+nXKl+X0QMJB/nqHkS5Qo10HoCvOfFyf6I9r6rpHxgxHDB1vqaa+0OlDh2qtDIng0TpiGhjPsVSGmVkO6kF9olT69UaI5FKwyILSDvNuBQ4vvLDsAuJAjMxwB+4vj8769/2oQfYYkoFt3Qw+wqswICLAfaIoUIRAx3rvNQQBxe1VwyMzwbQlQD+/POqX2DDAA=="
	Else
		Local $Code = "Uw8AAIkAwIPsLItEJDDoUHwId1R7EMwINBEM/+syDQgdOCcE50A//X+c6DUwAoPELDjCEH5k224cXHz02VkIIJERCCIsRAQooy+qChEcEFVXVgxTgeyMf4sZnCSwD8eyXwwEjgis/wOJbhxejA4/hPCgi7uU+qSFB4wjDrTyqCGDwAHpvFYRy3tMOwKNBwHfg8F8G3zp/wHkD7YGiAeL07i3FsbAJEv/wegJHQHQJdh/2QSD3GkUMepkfKxAAQ+GAwSpZKgJopmGNlgBGXNnX87CvKdAyhlgERQ/BSFLDS+AUe+FZ776CGRUchiKQCuUeLREZSuhkhhMYgPeLM6D+dWkMSD0dgEQCo1yHP87Sv8MhFcGHXTBPoHuP0RHk2Z8FIAIGcAK99AhxskBAsHpCYmCPByNBAGYyYs8A4M5/g+POvUythhOFzE5x1RMBkHVjSJIGHiiUSSSMDJcS88wGDgxIIPuZwGdcHXoJ+CT6yroy4tMyj34XEOEgTYKApo0YxzEyAMzr/ikwBwRidmZx6U4gMocPmY5y3VVyaYDyAEYurkOC3cM3znOhfattJnr4qyYkgH9kIxwRQk6AnWfBXRmQ4JS6xB3Ig4FAYPpbzrOAup11QHwhcmNcIwS6Tt6MNqyRY8Z80QGi2zSiEygo8UBKfkfOfVysdkYgDQpdm8LN8DB5Qc56SlyDwsQA3oxgztrgf5JiROfAqCHpQeSb1OEhVVv46a/hP4o6RNddwo1kf4OKRoi9CQ7Fol2BBkc+J19GSBmgOQ/miqE7vqBtAJQ3SjB4AYECAaJ9R2Il8Do+oh2RlC4QdChhy+kUtRsTETUglZmIijlbyAq3yKKuwfk/6bHNJhDwBgcdgW+N99ZisYB4pIYGxlVt6Q0wL7PgeeRgAHB7glmA6Qe5ImB5hiQLLM5iQzM339AORj0rEi7nYV1z0KrHDmEZmGhMh5CZlTGe9tEELDpgf2r5nu6kF0SD5XBRztE+PgBic52CISKIoUi3aB6kplpWOoQjSnH8OnKHUDzkks2L0pv2KdK8S8IJQQWgwY6OXwvPocY1uVI8KQi5vbKIEB1hA3UNxtlektd8InB4Q8rtQ4YwOkUTwGRTY+NfRJAACh0BMZF80mC8TlirQqD6gU5RD+ZOubHZhmIKmBCgbxJrIsigSwYyqgb9VfqqbCqDIM5iTTJSBqB4h4ajMSJ6eCMk5nBqx6Nh+KBE4AvFBaFsKTNVK3VRIPh4gGF0iMqfZVLk3I7iBEutHJiK4QZA3LCBQaBxIzMOFsJXl9dw5SLoHhBApHzpIQS5hWvHzU/JCI3gYgLVD8ULgIOyESEh+EDTu4JESJPzgJuXiZmBCBsxvGRMrUPHy8T/RAD2gnFAogNNyCyClZ0CYMy+BExoKu9PRDyhk3ZtxmNSO5tgyGkFU0xuIRdisuITZZpLKWSCNmHHunbLmuLAqYqJBqIgXwkEKazERsJRDnPmKuGNZInicZUE/tNi1wqRJofQMHtbFI6C41V/IZ81WmBwuJDOyWC/MkiysgJwppwwe62B4Pg1YjWpYhfRNViAZlRQRjiBIlCiBdrHt2RL0cBSAoMgkHuwlLXX2s3tNiOQJieSMZPQYHVBZ0OA/IIBC9qD4GkowDwjTzvAe2xOgJ0IIu8zNNI6ow0AzmDAgffNQaFKwsF6oVE8gmirmoQUh7d+vMXKCXhHBa/iatAki1YmsclIB6/E+ml/ElsfGpDBaL9FNFDTeKG6RkxrrMhNQFi7gROttRZrWpbq1iHVVP+MVCl/ZOaGBRxg+HwiExN7cUvCJAc6cL71d+rEwH2IEB/dpyaIPkJ1hPUCjRtWAiI29SYzs/F2+uZSdxACppmh4nGZjQQgzkEsMdAAtmeDAYlyPvUssIL6bv+mAkguEoKCRqDgVyB+QuLE3cPpxmEBQLN/GDy6JBpB7ZKBDpOPC7sSAENzzDRKLkFDIne6w08HGsKSo6ywv91B+iJhcDu7KnUMNHzOQfD6bj6VOtFAbsNCoXz2awNxHQBiA7p/KMhyCorVQ/DSZHU6dFS"
		$Code &= "/id8kUgoGcQx6d+KOQN0d42I71gbLXDqiaQjkCShGg8y0SwBdmp/IAxNAuyIAxEMjZ1rWqFq5KNJslERd1oWbQJAg8rwiFZAKkYDpA6gQ+m+0DV3jICU8LqooVCJssR4BJCC6UOvryGF5gG/funUP/0JA3VnuSrYwlk7kUyTCc7NZTuRQY/pjfmmZn0gdJowKggWDjLA6hRWhKlwjUclqiIz1Yh3mr816TY1iU36JAPdLd+EZAqzN5cUEPdH9UCZavcmEkP+bTBBCK9U0y2OyBEwBArp7/grkhiJkXCOQLEbRwGbJIJYoJJfEukL+jQ/zCX1IYgGYvT4RXnKmbLed054IOL8uUuTuCXnyU5ilktxoulxgIVVMe1XVr6hUVNskdyszpdIJyPGOOVSiG1pIYbi6yAG0ynROc7MVRS9jx6E21zTO1DWMd0xPhQyLB9UTYjeJPIdMURi0Bf3o+sqwFwnRTMl598XV8HjArXaiBHrRp5N62KZAwh0kNBkGWyJ6UbRRnnpe/EnhnmJS+Acg3HxM7I4FBd4GTXJgIvBhNIpdaZaY+uwS3YcS9KPjYaQLwySxhsUU9mpCbcMMSMxCctzEks9Mly+xH37cTEg2OuYNHP595luKIJo7gwaA8gSnmQBCnPv44nZLFY/nKHzHIjkTgfqgPLOrNVAr5mElhwKIeOpH/vyILUvgcMDOcFwo/TEF40UD9dmgsiNtD4LhgrIgcKDCusBKcrLagESEE+YKO3Rx/uywkNwazfLYRk7QfEQdmjNFjGJEEOga1EAFtt14YvSEyAa6cH+wpPL0euIlaSbvNO61pOm+vWAldmB4f9BB9nBbGdwr6+KhVGBoa+qHkTr26S1KYVLlz/gHY1UMwFKORTcDsSCL1p0gGx0dotUhCQcMsZtpKV3JnvTZSWB+6KvdGeE9BJGhgyVvLgJuASef6p+mI/pgqq1sZ8cCIjBFhTp0v2U99kWQMt/kWCyOIiDoOmbQll20GeGdZlTVCilAoSAobMBjPXP/Ir6OrfRwiViCcEiIZJYdA7SZioLVNR4txuNmhFZIKYCWxBUzhNp1TE/TQsKTDP8dR3hopA4XAUzgRSD4n+O9BEEhxwSf4nQEdU8qF+VJHQw2Ql2LBl9621xUcdEaoNTDVAbxgSj0Z49Fw6LKlL8xkZcC4kpdeUBgOme/FneaKTJKBJUgrBBBAqshOmg/ZknRdMQzx/UFFTVA4MkoEEdRn5FgYwyJwY4j0TpxJeA8aADdEgrY6fF2h6zJKgaDmVUcEoTTBGNFowTQYEw6Tmmi8XkMWVaJl8MLH8xxG/ry4yDt4CBw5E2CenFJCy4jUBF5CjfRDSJAx32vBi4Ajvr4e/ahQfamHtUBzH7geLAiyANDBLpsaFCAxHrvN0QQQe1V71NEoXJF0hFiQxpxhcDsuYJCPfHA5BaCqpSSQoAdfaJysHpAh7886sW0V23xqpfwwA="
	EndIf
	Local $Opcode = String(_LZMAT_CodeDecompress($Code))
	Local Const $_LZMAT_Compress = (StringInStr($Opcode, "89C0") + 1) / 2
	Local Const $_LZMAT_Decompress = (StringInStr($Opcode, "89DB") + 1) / 2
	$Opcode = Binary($Opcode)
	Local $_LZMAT_CodeBufferMemory = DllCall("kernel32.dll", "ptr", "VirtualAlloc", "ptr", 0, "ulong_ptr", BinaryLen($Opcode), "dword", $MEM_COMMIT, "dword", $PAGE_EXECUTE_READWRITE)
	$_LZMAT_CodeBufferMemory = $_LZMAT_CodeBufferMemory[0]
	Local Const $_LZMAT_CodeBuffer = DllStructCreate("byte[" & BinaryLen($Opcode) & "]", $_LZMAT_CodeBufferMemory)
	DllStructSetData($_LZMAT_CodeBuffer, 1, $Opcode)
	Local Const $OutputLen = Int(BinaryMid($Data, 1, 4))
	$Data = BinaryMid($Data, 5)
	Local Const $InputLen = BinaryLen($Data)
	Local Const $Input = DllStructCreate("byte[" & $InputLen & "]")
	DllStructSetData($Input, 1, $Data)
	Local Const $Output = DllStructCreate("byte[" & $OutputLen & "]")
	Local Const $Ret = DllCallAddress("uint", DllStructGetPtr($_LZMAT_CodeBuffer) + $_LZMAT_Decompress, "struct*", $Input, "uint", $InputLen, "struct*", $Output, "uint*", $OutputLen)
	DllCall("kernel32.dll", "bool", "VirtualFree", "ptr", $_LZMAT_CodeBufferMemory, "ulong_ptr", 0, "dword", $MEM_RELEASE)
	Return BinaryMid(DllStructGetData($Output, 1), 1, $Ret[4])
EndFunc   ;==>ASM_DecompressLZMAT

Func _LZMAT_CodeDecompress($Code)
	Local Const $MEM_COMMIT = 4096, $PAGE_EXECUTE_READWRITE = 64, $MEM_RELEASE = 32768
	If @AutoItX64 Then
		Local $Opcode = "0x89C04150535657524889CE4889D7FCB28031DBA4B302E87500000073F631C9E86C000000731D31C0E8630000007324B302FFC1B010E85600000010C073F77544AAEBD3E85600000029D97510E84B000000EB2CACD1E8745711C9EB1D91FFC8C1E008ACE8340000003D007D0000730A80FC05730783F87F7704FFC1FFC141904489C0B301564889FE4829C6F3A45EEB8600D275078A1648FFC610D2C331C9FFC1E8EBFFFFFF11C9E8E4FFFFFF72F2C35A4829D7975F5E5B4158C389D24883EC08C70100000000C64104004883C408C389F64156415541544D89CC555756534C89C34883EC20410FB64104418800418B3183FE010F84AB00000073434863D24D89C54889CE488D3C114839FE0F84A50100000FB62E4883C601E8C601000083ED2B4080FD5077E2480FBEED0FB6042884C00FBED078D3C1E20241885500EB7383FE020F841C01000031C083FE03740F4883C4205B5E5F5D415C415D415EC34863D24D89C54889CE488D3C114839FE0F84CA0000000FB62E4883C601E86401000083ED2B4080FD5077E2480FBEED0FB6042884C078D683E03F410845004983C501E964FFFFFF4863D24D89C54889CE488D3C114839FE0F84E00000000FB62E4883C601E81D01000083ED2B4080FD5077E2480FBEED0FB6042884C00FBED078D389D04D8D7501C1E20483E03041885501C1F804410845004839FE747B0FB62E4883C601E8DD00000083ED2B4080FD5077E6480FBEED0FB6042884C00FBED078D789D0C1E2064D8D6E0183E03C41885601C1F8024108064839FE0F8536FFFFFF41C7042403000000410FB6450041884424044489E84883C42029D85B5E5F5D415C415D415EC34863D24889CE4D89C6488D3C114839FE758541C7042402000000410FB60641884424044489F04883C42029D85B5E5F5D415C415D415EC341C7042401000000410FB6450041884424044489E829D8E998FEFFFF41C7042400000000410FB6450041884424044489E829D8E97CFEFFFF56574889CF4889D64C89C1FCF3A45F5EC3E8500000003EFFFFFF3F3435363738393A3B3C3DFFFFFFFEFFFFFF000102030405060708090A0B0C0D0E0F10111213141516171819FFFFFFFFFFFF1A1B1C1D1E1F202122232425262728292A2B2C2D2E2F3031323358C3"
	Else
		Local $Opcode = "0x89C0608B7424248B7C2428FCB28031DBA4B302E86D00000073F631C9E864000000731C31C0E85B0000007323B30241B010E84F00000010C073F7753FAAEBD4E84D00000029D97510E842000000EB28ACD1E8744D11C9EB1C9148C1E008ACE82C0000003D007D0000730A80FC05730683F87F770241419589E8B3015689FE29C6F3A45EEB8E00D275058A164610D2C331C941E8EEFFFFFF11C9E8E7FFFFFF72F2C32B7C2428897C241C61C389D28B442404C70000000000C6400400C2100089F65557565383EC1C8B6C243C8B5424388B5C24308B7424340FB6450488028B550083FA010F84A1000000733F8B5424388D34338954240C39F30F848B0100000FB63B83C301E8CD0100008D57D580FA5077E50FBED20FB6041084C00FBED078D78B44240CC1E2028810EB6B83FA020F841201000031C083FA03740A83C41C5B5E5F5DC210008B4C24388D3433894C240C39F30F84CD0000000FB63B83C301E8740100008D57D580FA5077E50FBED20FB6041084C078DA8B54240C83E03F080283C2018954240CE96CFFFFFF8B4424388D34338944240C39F30F84D00000000FB63B83C301E82E0100008D57D580FA5077E50FBED20FB6141084D20FBEC278D78B4C240C89C283E230C1FA04C1E004081189CF83C70188410139F374750FB60383C3018844240CE8EC0000000FB654240C83EA2B80FA5077E00FBED20FB6141084D20FBEC278D289C283E23CC1FA02C1E006081739F38D57018954240C8847010F8533FFFFFFC74500030000008B4C240C0FB60188450489C82B44243883C41C5B5E5F5DC210008D34338B7C243839F3758BC74500020000000FB60788450489F82B44243883C41C5B5E5F5DC210008B54240CC74500010000000FB60288450489D02B442438E9B1FEFFFFC7450000000000EB9956578B7C240C8B7424108B4C241485C9742FFC83F9087227F7C7010000007402A449F7C702000000740566A583E90289CAC1E902F3A589D183E103F3A4EB02F3A45F5EC3E8500000003EFFFFFF3F3435363738393A3B3C3DFFFFFFFEFFFFFF000102030405060708090A0B0C0D0E0F10111213141516171819FFFFFFFFFFFF1A1B1C1D1E1F202122232425262728292A2B2C2D2E2F3031323358C3"
	EndIf
	Local Const $AP_Decompress = (StringInStr($Opcode, "89C0") - 3) / 2
	Local Const $B64D_Init = (StringInStr($Opcode, "89D2") - 3) / 2
	Local Const $B64D_DecodeData = (StringInStr($Opcode, "89F6") - 3) / 2
	$Opcode = Binary($Opcode)
	Local $CodeBufferMemory = DllCall("kernel32.dll", "ptr", "VirtualAlloc", "ptr", 0, "ulong_ptr", BinaryLen($Opcode), "dword", $MEM_COMMIT, "dword", $PAGE_EXECUTE_READWRITE)
	$CodeBufferMemory = $CodeBufferMemory[0]
	Local Const $CodeBuffer = DllStructCreate("byte[" & BinaryLen($Opcode) & "]", $CodeBufferMemory)
	DllStructSetData($CodeBuffer, 1, $Opcode)
	Local Const $B64D_State = DllStructCreate("byte[16]")
	Local Const $Length = StringLen($Code)
	Local Const $Output = DllStructCreate("byte[" & $Length & "]")
	DllCallAddress("none", DllStructGetPtr($CodeBuffer) + $B64D_Init, "struct*", $B64D_State, "int", 0, "int", 0, "int", 0)
	DllCallAddress("int", DllStructGetPtr($CodeBuffer) + $B64D_DecodeData, "str", $Code, "uint", $Length, "struct*", $Output, "struct*", $B64D_State)
	Local Const $ResultLen = DllStructGetData(DllStructCreate("uint", DllStructGetPtr($Output)), 1)
	Local $Result = DllStructCreate("byte[" & ($ResultLen + 16) & "]"), $Ret
	If @AutoItX64 Then
		$Ret = DllCallAddress("uint", DllStructGetPtr($CodeBuffer) + $AP_Decompress, "ptr", DllStructGetPtr($Output) + 4, "struct*", $Result, "int", 0, "int", 0)
	Else
		$Ret = DllCall("user32.dll", "uint", "CallWindowProc", "ptr", DllStructGetPtr($CodeBuffer) + $AP_Decompress, "ptr", DllStructGetPtr($Output) + 4, "ptr", DllStructGetPtr($Result), "int", 0, "int", 0)
	EndIf
	DllCall("kernel32.dll", "bool", "VirtualFree", "ptr", $CodeBufferMemory, "ulong_ptr", 0, "dword", $MEM_RELEASE)
	Return BinaryMid(DllStructGetData($Result, 1), 1, $Ret[0])
EndFunc   ;==>_LZMAT_CodeDecompress
#EndRegion flags
